package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.impl.ShipWeaponsLocationFactory;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 23, 2014
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class RefitShipTask extends TimedTask {

    private final IShip ship;
    private final EShipUpgrade level;
    protected final ICityPlayerProxyJFX city;
    private final IShipyard shipyard;
    @Autowired
    @XStreamOmitField
    private ShipWeaponsLocationFactory shipWeaponLocationFactory;
    @Autowired
    @XStreamOmitField
    @Qualifier("serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    @Qualifier("messageSource")
    private MessageSource messageSource;

    public RefitShipTask(DateTime executionTime, IShip ship, EShipUpgrade upgrade, ICityPlayerProxyJFX city, IShipyard shipyard) {
        super();
        setExecutionTime(executionTime);
        this.ship = ship;
        level = upgrade;
        this.city = city;
        this.shipyard = shipyard;
    }

    @Override
    public void run() {
        while (ship.getShipUpgradeLevel() != level) {
            ship.upgrade();
            ((IShip)ship).setShipWeaponsLocation(shipWeaponLocationFactory.getShipWeaponsLocation(ship.getShipType(), level));
        }
        ship.setAvailable(true);
        city.getPlayersShips().add(ship);
        shipyard.removeCompletedUpgrade(ship);
        if (city.getPlayersShips().size() == 1) {
            city.activateShip(ship);
        }
        int currentCapacity = ship.getCapacity();

        if (ship.getOwner() instanceof IHumanPlayer) {
            DisplayMessage msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.event.task.RefitShipTask.message", new Object[]{ship.getShipType(), level, currentCapacity});
            TargetedEvent displayMessage = new TargetedEvent((IHumanPlayer) ship.getOwner(), msg);
            clientServerEventBus.post(displayMessage);
        }
        // TODO: andi 7/21/16 add notification for AI
    }
}
