package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.event.data.PeriodicalTimeWeekEndUpdate;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.StateFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.ModelStateAccessor;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.event.task.ServerSideTaskFactory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.EChurchExtension;
import ch.sahits.game.openpatrician.model.city.IChurch;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.collection.CityChurchRegistry;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import java.util.Collections;
import java.util.List;
import java.util.Random;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 21, 2015
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class ChurchEngine extends AbstractEngine {
    @Autowired
    @Qualifier("timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private Random rnd;
    @Autowired
    private Date date;
    @Autowired
    private TimedUpdatableTaskList timedTaskListener;
    @Autowired
    private StateFactory stateFactory;
    @Autowired
    private CityChurchRegistry churchMap;
    @Autowired
    private ModelStateAccessor churchProvider;
    @Autowired
    private ServerSideTaskFactory taskFactory;

    @PostConstruct
    private void init() {
        timerEventBus.register(this);
    }
    @PreDestroy
    private void unregister() {
        timerEventBus.unregister(this);
    }
    @Override
    public List<AbstractEngine> getChildren() {
        return Collections.EMPTY_LIST;
    }
    @Subscribe
    public void handleWeeklyUpdate(PeriodicalTimeWeekEndUpdate event) {
        // check if an upgrade can be made
        for (ICity iCity : churchMap.keySet()) {
            IChurch church =  churchProvider.getChurch(iCity);
            if (church.getExtensionLevel().getNextExtensionLevel().isPresent()) {
                EChurchExtension next = church.getExtensionLevel().getNextExtensionLevel().get();
                final int collectedDonationsForExtension = church.getCollectedDonationsForExtension();
                if (collectedDonationsForExtension >= next.getRequiredCash()) {
                    // start upgrade
                    int delay = rnd.nextInt(30);
                    DateTime executionTime = date.getCurrentDate().plusDays(delay);
                    TimedTask task = taskFactory.getChurchUpgradeTask(church, executionTime);
                    timedTaskListener.add(task);
                }
            }
        }
    }
    public void establishChurch(ICity city) {
        IChurch church = stateFactory.createChurch();
        churchMap.put(city, church);
    }

}
