package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.service.GuildService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.guild.GuildList;
import ch.sahits.game.openpatrician.model.city.guild.IGuild;
import ch.sahits.game.openpatrician.model.player.IAIGuildJoinStrategy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Optional;

/**
 * Always join the guild if the player has a certain amount of cash dependent on the entry fee.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 15, 2016
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
@LazySingleton
public class AlwaysJoinGuildMinCashStrategy implements IAIGuildJoinStrategy {
    private static final int ENTRY_FEE_FACTOR = 10;
    @Autowired
    private GuildList guildList;
    @Autowired
    private GuildService guildService;

    @Override
    public boolean shouldJoin(IAIPlayer player, ICity city, Optional<INavigableVessel> vessel) {
        Optional<IGuild> maybeGuild = guildList.findGuild(city);
        if (maybeGuild.isPresent()) {
            IGuild guild = maybeGuild.get();
            if (guild.getMembers().contains(player)) {
                return false;
            } else {
                ICompany company = player.getCompany();
                int fee = guildService.getEntryFee(player);
                if (fee * ENTRY_FEE_FACTOR < company.getCash()) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void join(IAIPlayer player, ICity city) {
        ICompany company = player.getCompany();
        Optional<IGuild> maybeGuild = guildList.findGuild(city);
        IGuild guild = maybeGuild.get();
        int fee = guildService.getEntryFee(player);
        company.updateCash(-fee);
        guild.join(player);
    }
}
