package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.PersonLeavesTavernEvent;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.impl.CaptainsState;
import ch.sahits.game.openpatrician.model.player.IAICaptainHireStrategy;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.Optional;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 31, 2016
 */
public abstract class BaseHireCaptainStrategy implements IAICaptainHireStrategy {
    @Autowired
    protected CaptainsState captainsState;
    @Qualifier("serverClientEventBus")
    @XStreamOmitField
    @Autowired
    private AsyncEventBus clientServerEventBus;
    @Override
    public Optional<ICaptain> getCaptain(ICity city) {
        Optional<ICaptain> optCaptain = captainsState.getCaptain(city);
        return optCaptain;
    }
    @Override
    public void hire(IAIPlayer player, IShip vessel, ICaptain captain, ICity city) {
        vessel.setCaptain(captain);
        captainsState.hireCaptain(captain, city);
        clientServerEventBus.post(new PersonLeavesTavernEvent(city, captain));
    }
}
