package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.model.ship.EShipType;

/**
 * Strategy to collect wares to construct a snaikka.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 26, 2016
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class CollectConstructionHometownSnaikkaWareStrategy extends CollectionConstructionHometownWaresStrategy {
    public CollectConstructionHometownSnaikkaWareStrategy() {
        super(EShipType.SNAIKKA);
    }

    @Override
    protected IAITradeStrategyType getStrategyType() {
        return ECollectWareStrategyType.HOMETOWN_SNAIKKA;
    }
}
