package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.EShipType;

/**
 * This implementation for construction provides construction location in the players hometown.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 30, 2016
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public abstract class CollectionConstructionHometownWaresStrategy extends CollectConstructionWareStrategy {
    public CollectionConstructionHometownWaresStrategy(EShipType constructionType) {
        super(constructionType);
    }

    @Override
    protected ICity getConstructionCity(IAIPlayer player) {
        return player.getHometown();
    }
}
