package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.player.IAIShipRepairStrategy;
import ch.sahits.game.openpatrician.model.player.IAIShipRepairStrategyType;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

/**
 * Strategy type for the repair of the ship.
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public enum EAIRepairStrategy implements IAIShipRepairStrategyType {
    EIGHTY_PERCENT(EightyPercentRepairStrategy.class),
    ONLY_HOMEWOTN(HometownRepairStrategy.class),
    ONLY_WEST(WestRepairStrategy.class),
    ONLY_TRADINGOFFICE(OnlyTradingOfficeRepairStrategy.class),
    ONLY_KONTOR_TYPE(KontorTypeCityRepairStrategy.class);
    @XStreamOmitField
    private ApplicationContext context;
    private final Class<? extends IAIShipRepairStrategy> strategyClass;

    EAIRepairStrategy(Class<? extends IAIShipRepairStrategy> strategyClass) {
        this.strategyClass = strategyClass;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Override
    public IAIShipRepairStrategy getStrategy() {
        return context.getBean(strategyClass);
    }
}
