package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.player.IAITradeStrategy;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

/**
 * The types for the collection strategies.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 30, 2016
 */
public enum ECollectWareStrategyType implements IAITradeStrategyType {
    HOMETOWN_SNAIKKA(CollectConstructionHometownSnaikkaWareStrategy.class),
    HOMETOWN_CRAYER(CollectConstructionHometownCrayerWareStrategy.class),
    HOMETOWN_COG(CollectConstructionHometownCogWareStrategy.class),
    HOMETOWN_HOLK(CollectConstructionHometownHolkWareStrategy.class),
    CELEBRATION(CollectCelebrationWaresStrategy.class);
    @XStreamOmitField
    private ApplicationContext context;
    private final Class<? extends CollectionWaresStrategy> strategyClass;

    ECollectWareStrategyType(Class<? extends CollectionWaresStrategy> strategyClass) {
        this.strategyClass = strategyClass;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Override
    public IAITradeStrategy getStrategy() {
        return context.getBean(strategyClass);
    }
}
