package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.player.IAIGuildJoinStrategy;
import ch.sahits.game.openpatrician.model.player.IAIGuildJoinStrategyType;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 15, 2016
 */
public enum EGuildJoinStrategyType implements IAIGuildJoinStrategyType {
    ALWAYS_JOIN_MIN_CASH(AlwaysJoinGuildMinCashStrategy.class);
    @XStreamOmitField
    private ApplicationContext context;
    private final Class<? extends IAIGuildJoinStrategy> strategyClass;

    EGuildJoinStrategyType(Class<? extends IAIGuildJoinStrategy> strategyClass) {
        this.strategyClass = strategyClass;
    }

    public void setApplicationContext(org.springframework.context.ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Override
    public IAIGuildJoinStrategy getStrategy() {
        return context.getBean(strategyClass);
    }
}
