package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.player.IAIConstructionSelectionStrategy;
import ch.sahits.game.openpatrician.model.player.IAIConstructionSelectionStrategyType;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

/**
 * Strategy type for constructing ships.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 30, 2016
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public enum EShipConstructionStrategyType implements IAIConstructionSelectionStrategyType {
    HOMETOWN_BIGEST(HometownBiggestShipConstructionSelectionStrategy.class);
    @XStreamOmitField
    private ApplicationContext context;
    private final Class<? extends IAIConstructionSelectionStrategy> strategyClass;

    EShipConstructionStrategyType(Class<? extends IAIConstructionSelectionStrategy> strategyClass) {
        this.strategyClass = strategyClass;
    }

    public void setApplicationContext(org.springframework.context.ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Override
    public IAIConstructionSelectionStrategy getStrategy() {
        return context.getBean(strategyClass);
    }

}
