package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.IAIEventDecisionStrategy;

/**
 * Strategy for taking event decitions based on the size of the fleet.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 18, 2016
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
@LazySingleton
public class FleetBasedEventDecisionStrategy implements IAIEventDecisionStrategy {
    @Override
    public boolean acceptMarriagBrokereOffer(IAIPlayer player) {
        return isFleetLargeEnough(player);
    }

    @Override
    public boolean acceptMarriageOffer(IAIPlayer player) {
        return isFleetLargeEnough(player);
    }

    @Override
    public boolean shouldOrderCelebration(IAIPlayer player, ICity city) {
        return isFleetLargeEnough(player);
    }

    private boolean isFleetLargeEnough(IPlayer player) {
        return player.getFleet().size() > 8;
    }
}
