package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.google.common.base.Preconditions;

/**
 * Repair strategy to repair the ship in the hometown.
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
@LazySingleton
public class HometownRepairStrategy extends BaseRepairStrategy {
    /**
     * Only repair the ship in the hometown unless it is realy badly damaged.
     * @param vessel that should be checked for repair need.
     * @param city current possition of the vessel.
     * @return
     */
    @Override
    public boolean shouldRepair(INavigableVessel vessel, ICity city) {
        Preconditions.checkArgument(vessel.getLocation().equals(city.getCoordinates()), "The vessel is not in city "+city.getName()+" but at "+vessel.getLocation());
        int damage = vessel.getDamage();
        if (damage > 90) {
            return true;
        }
        IAIPlayer player = (IAIPlayer) vessel.getOwner();
        if (city.equals(player.getHometown())) {
            return true;
        }
        return false;
    }
}
