package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.engine.player.strategy.BaseRepairStrategy;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.google.common.base.Preconditions;

/**
 * Repair strategy for only repairing in town where the player has a trading office.
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
@LazySingleton
public class OnlyTradingOfficeRepairStrategy extends BaseRepairStrategy {
    /**
     * Unless the damage is heave only in towns where hte vessel owner has a
     * trading office repairs should be conducted.
     * @param vessel that should be checked for repair need.
     * @param city current possition of the vessel.
     * @return
     */
    @Override
    public boolean shouldRepair(INavigableVessel vessel, ICity city) {
        Preconditions.checkArgument(vessel.getLocation().equals(city.getCoordinates()), "The vessel is not in city "+city.getName()+" but at "+vessel.getLocation());
        int damage = vessel.getDamage();
        if (damage > 90) {
            return true;
        }
        IAIPlayer owner = (IAIPlayer) vessel.getOwner();
        return owner.findTradingOffice(city).isPresent();
    }
}
