package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.property.SimpleIntegerProperty;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Base class for buy trade steps.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 24, 2016
 */
@Prototype
public abstract class AbstractBuyTradeStep implements ITradeStep {
    @Setter
    @Getter(AccessLevel.PROTECTED)
    private ICity city;
    @Setter
    @Getter
    private IWare ware;
    @Setter
    @Getter(AccessLevel.PROTECTED)
    private INavigableVessel vessel;

    @Setter
    private boolean executeNext = true;
    @Autowired
    @XStreamOmitField
    private ComputablePriceV2 computablePrice;

    /**
     * Execute the transaction of buying the ware from the city and moving it onto the ship
     * @param availableAmount amount available in the city
     * @param player doing the transaction
     * @param company of the player
     * @param affordableAmount amount that should be bought
     * @return true if the next trade step can be executed.
     */
    protected boolean buyWare(int availableAmount, IPlayer player, ICompany company, int affordableAmount) {
        if (affordableAmount > 0) {
            int buyPrice = computablePrice.buyPrice(ware, new SimpleIntegerProperty(availableAmount), new ConstantIntegerBinding(affordableAmount));
            company.updateCash(-buyPrice * affordableAmount);
            city.move(ware, -affordableAmount, player);
            vessel.load(ware, affordableAmount, buyPrice);
        }
        // TODO ahotz 20.05.2016: handle case where there are ships owned by other players in the convoy
        return executeNext;
    }
}
