package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.property.SimpleIntegerProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Implements the sell step for selling a single ware up to a minimum sell price
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class SellTradeStep implements ITradeStep {
    @Setter
    private ICity city;
    @Setter
    @Getter
    private IWare ware;
    @Setter
    private INavigableVessel vessel;
    @Autowired
    @XStreamOmitField
    private ComputablePriceV2 computablePrice;

    @Setter
    private boolean executeNext = true;

    @Override
    public boolean execute() {
        int availableAmount = city.getWare(ware).getAmount();
        int maxSellAmount = vessel.getWare(ware).getAmount();
        int minSellPrice = vessel.getWare(ware).getAVGPrice();
        int sellAmount = computablePrice.calculateSellAmount(ware, availableAmount, minSellPrice, maxSellAmount);
        if (sellAmount > 0) {
            int sellPrice = computablePrice.sellPrice(ware, new SimpleIntegerProperty(availableAmount), new ConstantIntegerBinding(sellAmount));
            IAIPlayer player = (IAIPlayer) vessel.getOwner();
            ICompany company = player.getCompany();
//            logger.trace("Before: cash={}, in city={}, on ship={}", company.getCash(), city.getWare(ware).getAmount(), vessel.getWare(ware).getAmount());
            company.updateCash(sellPrice * sellAmount);
            city.move(ware, sellAmount, player);
            vessel.load(ware, sellAmount, sellPrice);
//            logger.trace("Sold {} of {} for a total of: {} ", sellAmount, ware.name(), sellPrice * sellAmount);
//            logger.trace("After: cash={}, in city={}, on ship={}", company.getCash(), city.getWare(ware).getAmount(), vessel.getWare(ware).getAmount());
            // TODO ahotz 20.05.2016: handle case where there are ships owned by other players in the convoy
        }
        return executeNext;
    }
}
