/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event;

import ch.sahits.game.event.data.ClockTickDayChange;
import ch.sahits.game.event.data.DisplayEventVideo;
import ch.sahits.game.event.data.PeriodicalTimeMonthEndUpdate;
import ch.sahits.game.event.data.PeriodicalTimeWeekEndUpdate;
import ch.sahits.game.event.data.ShipEntersPortEvent;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.CelebrationState;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.ChildBirthState;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.ChildDeathState;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.DowryState;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.FireState;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageBrokerAnnouncementState;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageCelebrationState;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.SpouseDeathState;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.ShipFactory;
import ch.sahits.game.openpatrician.dialog.IDialogState;
import ch.sahits.game.openpatrician.dialog.TargetedDialogStateWrapper;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.event.EEventState;
import ch.sahits.game.openpatrician.engine.event.EventEngineState;
import ch.sahits.game.openpatrician.engine.event.EventService;
import ch.sahits.game.openpatrician.engine.event.task.PlageTimedTask;
import ch.sahits.game.openpatrician.engine.event.task.ServerSideTaskFactory;
import ch.sahits.game.openpatrician.engine.player.IAIEventHandler;
import ch.sahits.game.openpatrician.engine.player.SocialRankChecker;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DateService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.PlayerList;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.building.IHospital;
import ch.sahits.game.openpatrician.model.building.IWell;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.EEventMediaType;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.personal.IChild;
import ch.sahits.game.openpatrician.model.personal.IReputation;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.model.personal.impl.Child;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.ISnaikka;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import ch.sahits.game.openpatrician.util.service.DisableProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class EventEngine
extends AbstractEngine {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private Random rnd;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private Date date;
    @Autowired
    @Qualifier(value="serverTimer")
    private ScheduledExecutorService executor;
    @Autowired
    private ShipFactory shipFactory;
    @Autowired
    private IAIEventHandler aiEventHandler;
    @Autowired
    private SocialRankChecker rankChecker;
    @Autowired
    private PlayerList players;
    @Autowired
    private IMap map;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private DateService dateService;
    @Autowired
    private DisableProperties disableService;
    @Autowired
    private ServerSideTaskFactory taskFactory;
    @Autowired
    private EventService eventService;
    @Autowired
    private EventEngineState eventState;
    private static RandomNameLoader shipLoader = new RandomNameLoader("shipnames.properties");
    private static RandomNameLoader maleFirstNameLoader = new RandomNameLoader("firstnames.properties");
    private static RandomNameLoader femaleFirstNameLoader = new RandomNameLoader("female_firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
        this.timerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
        this.timerEventBus.unregister((Object)this);
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return new ArrayList<AbstractEngine>();
    }

    @Subscribe
    public void handleWrappedStateEvents(TargetedDialogStateWrapper dialogState) {
        if (this.disableService.randomEventsEnabled()) {
            if (dialogState.getState() instanceof MarriageCelebrationState) {
                this.handleMarriageState(dialogState);
            } else if (dialogState.getState() instanceof CelebrationState) {
                this.postToHumanPlayer(dialogState, "ch.sahits.game.openpatrician.engine.event.EventEngine.message.celebration.title", new Object[0]);
            } else {
                throw new IllegalStateException("No handling implemented for " + dialogState.getState().getClass().getName());
            }
        }
    }

    @VisibleForTesting
    void handleMarriageState(TargetedDialogStateWrapper wrappedDialogState) {
        ISnaikka ship;
        int capacity;
        IPlayer player = wrappedDialogState.getPlayer();
        MarriageCelebrationState marriageState = (MarriageCelebrationState)wrappedDialogState.getState();
        ISpouseData spouse = marriageState.getSpouseData();
        player.marry(spouse);
        this.eventState.resetMarriedState(player);
        long value = player.getCompany().getCompanyValue();
        ICity birthPlace = spouse.getBirthPlace();
        double x = birthPlace.getCoordinates().getX();
        if (value < 200000L) {
            capacity = this.shipFactory.calculateInitialCapacity(EShipType.SNAIKKA, x);
            ship = this.shipFactory.createSnaikka(shipLoader.getRandomName(), capacity);
        } else if (value < 1000000L) {
            capacity = this.shipFactory.calculateInitialCapacity(EShipType.CRAYER, x);
            ship = this.shipFactory.createCrayer(shipLoader.getRandomName(), capacity);
        } else {
            capacity = this.shipFactory.calculateInitialCapacity(EShipType.COG, x);
            ship = this.shipFactory.createCog(shipLoader.getRandomName(), capacity);
        }
        ship.damage(this.rnd.nextInt(50) + 10);
        ship.setLocation(player.getHometown().getCoordinates());
        ship.setOwner((IShipOwner)player);
        player.addShip((IShip)ship);
        if (this.rnd.nextBoolean()) {
            EWare ware = EWare.values()[this.rnd.nextInt(EWare.values().length)];
            int amount = ware.isBarrelSizedWare() ? this.rnd.nextInt(ship.getCapacity() / 2) : this.rnd.nextInt(ship.getCapacity() / 20);
            ship.load((IWare)ware, amount, 0);
        }
        IReputation rep = birthPlace.getReputation(player);
        int repConnectionCounsilman = 1500;
        int updateReputation = (int)(0.5 * (double)spouse.getPopularityInHerHomeTown());
        updateReputation += spouse.getConnectionsInHerHomeTown() * repConnectionCounsilman;
        rep.update(updateReputation += spouse.getConnectionsInHerHomeTown() * 2 * repConnectionCounsilman);
        rep = player.getHometown().getReputation(player);
        updateReputation = (int)(0.5 * (double)spouse.getPopularityInYourHomeTown());
        updateReputation += spouse.getConnectionsInYourHomeTown() * repConnectionCounsilman;
        rep.update(updateReputation += spouse.getConnectionsInYourHomeTown() * 2 * repConnectionCounsilman);
        if (player instanceof IHumanPlayer) {
            String descriptionKey = "ch.sahits.game.graphic.display.dialog.event.CelebrationDialog." + marriageState.getSuccess().name();
            DisplayEventVideo event = DisplayEventVideo.builder().mediaType(EEventMediaType.CELEBRATION).durationInSeconds(20).titleKey("ch.sahits.game.openpatrician.engine.event.EventEngine.message.wedding.title").titleParams(new Object[0]).descriptionKey(descriptionKey).descriptionParams(new Object[]{marriageState.getAmountGuests()}).build();
            this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)player, (Object)event));
            DowryState state = DowryState.builder().location(player.getHometown().getName()).date(this.date.getCurrentDate()).ship((IShip)ship).build();
            this.executor.schedule(() -> this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)player, (Object)wrappedDialogState)), 5L, TimeUnit.SECONDS);
            this.executor.schedule(() -> {
                if (player instanceof IHumanPlayer) {
                    this.clientServerEventBus.post((Object)new TargetedDialogStateWrapper(player, (IDialogState)state));
                    this.eventService.postToHumanPlayer((IDialogState)state, player, "ch.sahits.game.openpatrician.engine.event.EventEngine.message.dowry.title", new Object[0]);
                }
            }, 10L, TimeUnit.SECONDS);
        } else {
            this.logger.debug("Dowry ship {} of {} {} enters port", new Object[]{ship.getName(), player.getName(), player.getLastName()});
            this.aiEventHandler.initializeNewShip((IShip)ship, (IAIPlayer)player);
        }
    }

    private void postToHumanPlayer(TargetedDialogStateWrapper dialogState, String messageKey, Object ... messageParams) {
        IPlayer player = dialogState.getPlayer();
        this.eventService.postToHumanPlayer(dialogState.getState(), player, messageKey, messageParams);
    }

    @Subscribe
    public void handleShipEntersPort(ShipEntersPortEvent event) {
        INavigableVessel ship = event.getShip();
        if (ship.getOwner() instanceof IPlayer && this.disableService.randomEventsEnabled()) {
            IPlayer player = (IPlayer)ship.getOwner();
            Optional<EEventState> marriageState = this.eventState.getMarriageState(player);
            if (!player.getSpouseData().isPresent() && marriageState != null && !marriageState.isPresent()) {
                if (player instanceof IAIPlayer) {
                    MarriageBrokerAnnouncementState state = this.createMarriageBrokerAnnouncementState(event, ship);
                    this.aiEventHandler.handleMarriageEvent((IAIPlayer)player, state);
                } else if (player instanceof IHumanPlayer) {
                    MarriageBrokerAnnouncementState state = this.createMarriageBrokerAnnouncementState(event, ship);
                    this.eventService.postToHumanPlayer((IDialogState)state, player, "ch.sahits.game.openpatrician.engine.event.EventEngine.message.marriageOffer.title", new Object[0]);
                    this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)player, (Object)state));
                    this.eventState.setMarriageState(player, EEventState.MARRIAGE_UNDER_CONSIDERATION);
                }
            }
        }
    }

    private MarriageBrokerAnnouncementState createMarriageBrokerAnnouncementState(ShipEntersPortEvent event, INavigableVessel ship) {
        return MarriageBrokerAnnouncementState.builder().date(this.date.getCurrentDate()).location(event.getCity().getName()).fromFirstName(maleFirstNameLoader.getRandomName()).fromLastName(lastNameLoader.getRandomName()).toLastName(ship.getOwner().getLastName()).genderMale(((IPlayer)ship.getOwner()).getPersonalData().isMale()).build();
    }

    @Subscribe
    public void handleEndOfWeekUpdates(PeriodicalTimeWeekEndUpdate event) {
    }

    @Subscribe
    public void handleEndOfMonthUpdates(PeriodicalTimeMonthEndUpdate event) {
        this.rankChecker.doMonthlyCheck();
    }

    @Subscribe
    public void handleDailyUpdates(ClockTickDayChange event) {
        if (this.disableService.randomEventsEnabled()) {
            boolean catastopheEvent = this.handleCatastropheEvents();
            for (IPlayer player : this.players) {
                boolean childBirth = false;
                boolean spouseDeath = false;
                if (player.getSpouseData().isPresent() && !catastopheEvent) {
                    boolean spuseDeathSingle;
                    childBirth = this.rnd.nextInt(400 * (player.getChildren().size() + 1)) == 42;
                    int spouseDeathPropLimit = 5000;
                    boolean bl = spuseDeathSingle = this.rnd.nextInt(spouseDeathPropLimit) == 42;
                    if (!player.getPersonalData().isMale()) {
                        spuseDeathSingle = false;
                    }
                    boolean bl2 = spouseDeath = !childBirth && spuseDeathSingle;
                    if (childBirth) {
                        boolean male = this.rnd.nextBoolean();
                        String name = male ? maleFirstNameLoader.getRandomName() : femaleFirstNameLoader.getRandomName();
                        ChildBirthState state = ChildBirthState.builder().location(player.getHometown().getName()).date(this.date.getCurrentDate()).male(male).name(name).wifeDeath(spuseDeathSingle).build();
                        Child child = Child.builder().birthDate(this.date.getCurrentDate()).name(name).build();
                        player.getChildren().add(child);
                        if (spuseDeathSingle) {
                            player.spouseDies();
                        }
                        this.eventService.postToHumanPlayer((IDialogState)state, player, "ch.sahits.game.openpatrician.engine.event.EventEngine.message.childBirth.title", new Object[0]);
                    }
                    if (spouseDeath) {
                        SpouseDeathState state = SpouseDeathState.builder().location(player.getHometown().getName()).date(this.date.getCurrentDate()).build();
                        player.spouseDies();
                        this.eventService.postToHumanPlayer((IDialogState)state, player, "ch.sahits.game.openpatrician.engine.event.EventEngine.message.spouseDeath.title", new Object[0]);
                    }
                }
                this.handleChildDeathEvent(catastopheEvent, player, childBirth, spouseDeath);
            }
        }
    }

    @VisibleForTesting
    void handleChildDeathEvent(boolean catastopheEvent, IPlayer player, boolean childBirth, boolean spouseDeath) {
        if (!(catastopheEvent || spouseDeath || childBirth)) {
            boolean childDeath;
            int childDeathLimit = this.calculateChildDeathLimit(player);
            boolean bl = childDeath = !spouseDeath && childDeathLimit > 0 && this.rnd.nextInt(childDeathLimit) == 0;
            if (childDeath) {
                List<IChild> nonAdults = this.filterNonAdultChildren(player);
                IChild child = nonAdults.get(this.rnd.nextInt(nonAdults.size()));
                ChildDeathState state = ChildDeathState.builder().location(player.getHometown().getName()).date(this.date.getCurrentDate()).child(child).build();
                List children = player.getChildren();
                children.remove(child);
                this.eventService.postToHumanPlayer((IDialogState)state, player, "ch.sahits.game.openpatrician.engine.event.EventEngine.message.childDeath.titl", new Object[0]);
            }
        }
    }

    @VisibleForTesting
    boolean handleCatastropheEvents() {
        boolean catastopheEvent = false;
        int fireRnd = this.rnd.nextInt(1095);
        boolean fireProbability = fireRnd < 10;
        int plagueRnd = this.rnd.nextInt(1095);
        boolean plageProbability = plagueRnd < 1;
        this.logger.info("Random events fireRnd={}, plagueRnd={}, fireProbability={}, plageProbability={}, random event={}", new Object[]{fireRnd, plagueRnd, fireProbability, plageProbability, fireProbability || plageProbability});
        if (fireProbability || plageProbability) {
            ArrayList cities = new ArrayList(this.map.getCities());
            Collections.shuffle(cities);
            for (ICity city : cities) {
                int popultation = city.getPopulationBinding().get();
                StringBuilder sb = new StringBuilder().append("Refined probability for ").append(city.getName()).append(" ");
                if (fireProbability) {
                    int nbWells = city.findBuilding(IWell.class, Optional.empty()).size();
                    double reduction = popultation / (500 * (nbWells + 1));
                    fireProbability = this.rnd.nextDouble() * reduction * 1.5 > 1.0;
                    sb.append("reduction=").append(reduction).append(", fireProbability=").append(fireProbability).append(", ");
                }
                if (plageProbability && !fireProbability) {
                    double sanitatyInstitutions = (double)city.findBuilding(IHospital.class, Optional.empty()).size() + city.getPercentageRoad();
                    double reduction = (double)popultation / (1500.0 * sanitatyInstitutions);
                    plageProbability = this.rnd.nextDouble() * reduction * 1.5 > 1.0;
                    sb.append("reduction=").append(reduction).append(", plageProbability=").append(plageProbability).append(", ");
                }
                this.logger.debug(sb.toString());
                if (fireProbability) {
                    this.eventState.addFire(city, this.date.getCurrentDate());
                    int deathtoll = this.rnd.nextInt(popultation / 20);
                    String titleKey = "ch.sahits.game.openpatrician.engine.event.EventEngine.video.fire.title";
                    Object[] titleParams = new Object[]{city.getName()};
                    int buildingTotal = 0;
                    for (IPlayer player : this.players) {
                        Optional<ISpouseData> killedSpouse = this.eventService.calculateSpouseDeath(player, city);
                        int destroyBuildingUpperBound = Math.max(city.findBuilding(IBuilding.class, Optional.empty()).size(), 1);
                        FireState state = FireState.builder().location(city.getName()).date(this.date.getCurrentDate()).deathtoll(deathtoll).destroyedBuildings(this.rnd.nextInt(destroyBuildingUpperBound)).killedSpouse(killedSpouse).build();
                        buildingTotal += state.getDestroyedBuildings();
                        this.eventService.postToHumanPlayer((IDialogState)state, player, titleKey, titleParams);
                    }
                    DisplayEventVideo event = DisplayEventVideo.builder().mediaType(EEventMediaType.FIRE).durationInSeconds(20).titleKey(titleKey).titleParams(titleParams).descriptionKey("ch.sahits.game.openpatrician.engine.event.EventEngine.video.fire.description").descriptionParams(new Object[]{city.getName(), buildingTotal, deathtoll}).build();
                    for (IPlayer player : this.players) {
                        if (!(player instanceof IHumanPlayer)) continue;
                        this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)player, (Object)event));
                    }
                    city.setPopulation(city.getPopulation(EPopulationClass.POOR) - deathtoll, EPopulationClass.POOR);
                }
                if (plageProbability && !fireProbability) {
                    int duration = this.rnd.nextInt(180) + 30;
                    DateTime plagueStart = this.date.getCurrentDate();
                    DateTime plagueEnd = this.date.getCurrentDate().plusDays(duration);
                    PlageTimedTask plagueTask = this.taskFactory.getPlagueTask(popultation, duration, city, plagueStart, plagueEnd);
                    this.taskList.add((TimedTask)plagueTask);
                    this.eventState.addPlague(city, plagueEnd);
                }
                if (!(catastopheEvent = fireProbability || plageProbability)) continue;
                break;
            }
        }
        return catastopheEvent;
    }

    private int calculateChildDeathLimit(IPlayer player) {
        if (player.getChildren().isEmpty()) {
            return 0;
        }
        int noAdultChildren = this.filterNonAdultChildren(player).size();
        return 9000 / noAdultChildren;
    }

    private List<IChild> filterNonAdultChildren(IPlayer player) {
        return player.getChildren().stream().filter(child -> this.dateService.getAge(child.getBirthDate()) < 18).collect(Collectors.toList());
    }
}

