/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.event.data.RepairFinishedEvent;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="aIRepairTask")
@Scope(value="prototype")
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class AIRepairTask
extends TimedTask {
    @XStreamOmitField
    private static final Logger LOGGER = LogManager.getLogger(AIRepairTask.class);
    @Autowired
    @XStreamOmitField
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    private final IShip ship;
    private final IShipyard shipyard;

    public AIRepairTask(DateTime executionTime, IShip ship, IShipyard shipyard) {
        this.setExecutionTime(executionTime);
        LOGGER.debug("Add AIRepairTask for {} to be done at {}", new Object[]{ship.getName(), executionTime});
        this.ship = ship;
        this.shipyard = shipyard;
    }

    public void run() {
        this.ship.repair();
        this.shipyard.removeCompletedRepair(this.ship);
        this.ship.setAvailable(true);
        LOGGER.debug("Repaired ship {}", new Object[]{this.ship.getName()});
        this.clientServerEventBus.post((Object)new RepairFinishedEvent((INavigableVessel)this.ship));
    }
}

