/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.event.data.DisplayEventVideo;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.PlagueState;
import ch.sahits.game.openpatrician.dialog.IDialogState;
import ch.sahits.game.openpatrician.engine.event.EventService;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.PlayerList;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.EEventMediaType;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Optional;
import java.util.Random;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class PlageTimedTask
extends TimedTask {
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Autowired
    private PlayerList players;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @XStreamOmitField
    private EventService eventService;
    private int popultation;
    private int duration;
    private ICity city;
    private DateTime plagueStart;
    private DateTime plagueEnd;

    public PlageTimedTask(int popultation, int duration, ICity city, DateTime plagueStart, DateTime plagueEnd) {
        this.popultation = popultation;
        this.duration = duration;
        this.city = city;
        this.plagueStart = plagueStart;
        this.plagueEnd = plagueEnd;
        this.setExecutionTime(plagueEnd);
    }

    public void run() {
        int deathtoll = this.rnd.nextInt(this.popultation / 10);
        int durationInMonth = this.duration / 30;
        String titleKey = "ch.sahits.game.openpatrician.engine.event.EventEngine.video.plague.title";
        Object[] titleParams = new Object[]{this.city.getName()};
        DisplayEventVideo event = DisplayEventVideo.builder().mediaType(EEventMediaType.PLAGUE).durationInSeconds(30).titleKey(titleKey).titleParams(titleParams).descriptionKey("ch.sahits.game.openpatrician.engine.event.EventEngine.video.plague.description").descriptionParams(new Object[]{this.city.getName(), deathtoll, durationInMonth}).build();
        for (IPlayer player : this.players) {
            Optional<ISpouseData> killedSpouse = this.eventService.calculateSpouseDeath(player, this.city);
            PlagueState state = PlagueState.builder().location(this.city.getName()).date(this.plagueEnd).deathtoll(deathtoll).killedSpouse(killedSpouse).since(this.plagueStart).build();
            this.eventService.postToHumanPlayer((IDialogState)state, player, titleKey, titleParams);
            if (!(player instanceof IHumanPlayer)) continue;
            this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)player, (Object)event));
        }
        this.city.setPopulation(this.city.getPopulation(EPopulationClass.POOR) - deathtoll, EPopulationClass.POOR);
    }
}

