/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageBrokerAnnouncementState;
import ch.sahits.game.openpatrician.clientserverinterface.service.ClientServerTaskFactory;
import ch.sahits.game.openpatrician.engine.event.task.AIRepairTask;
import ch.sahits.game.openpatrician.engine.event.task.ChurchUpgradeTimedTask;
import ch.sahits.game.openpatrician.engine.event.task.LoanerCollectMoneyAfterAuctionTimedTask;
import ch.sahits.game.openpatrician.engine.event.task.LoanerCollectMoneyWithoutAuctionTimedTask;
import ch.sahits.game.openpatrician.engine.event.task.MarriageOfferDeclinedTimedTask;
import ch.sahits.game.openpatrician.engine.event.task.MarriageOfferTask;
import ch.sahits.game.openpatrician.engine.event.task.PlageTimedTask;
import ch.sahits.game.openpatrician.engine.event.task.RefitShipTask;
import ch.sahits.game.openpatrician.engine.event.task.RepairPirateShipTask;
import ch.sahits.game.openpatrician.engine.event.task.RepairTask;
import ch.sahits.game.openpatrician.engine.event.task.ShipBuildTask;
import ch.sahits.game.openpatrician.engine.event.task.WeeklyCityCheckTask;
import ch.sahits.game.openpatrician.engine.event.task.WeeklyLoanerCheckTask;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.IChurch;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.city.impl.IShipBuildTask;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import javafx.geometry.Point2D;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ServerSideTaskFactory
extends ClientServerTaskFactory {
    @Autowired
    private ApplicationContext context;

    public TimedTask getRepairTask(DateTime executionTime, IShip ship, ICityPlayerProxyJFX proxy, IShipyard shipyard) {
        Object[] args = new Object[]{executionTime, ship, proxy, shipyard};
        return (RepairTask)((Object)this.context.getBean("repairTask", args));
    }

    public IShipBuildTask getShipBuildTask(DateTime executionTime, EShipType type, IPlayer owner, Point2D location, IShipyard shipyard) {
        Object[] args = new Object[]{executionTime, type, owner, location, shipyard};
        return (ShipBuildTask)((Object)this.context.getBean("shipBuildTask", args));
    }

    public TimedTask getRefitShipTask(DateTime executionTime, IShip ship, EShipUpgrade upgrade, ICityPlayerProxyJFX proxy, IShipyard shipyard) {
        Object[] args = new Object[]{executionTime, ship, upgrade, proxy, shipyard};
        return (RefitShipTask)((Object)this.context.getBean("refitShipTask", args));
    }

    public TimedTask getPirateRepairTask(DateTime dueDate, INavigableVessel vessel, ISeaPirate owner, IShipyard shipyard) {
        Object[] args = new Object[]{dueDate, vessel, owner, shipyard};
        return (RepairPirateShipTask)((Object)this.context.getBean("repairPirateShipTask", args));
    }

    public TimedTask getAIShipRepairTask(DateTime dueDate, IShip ship, IShipyard shipyard) {
        Object[] args = new Object[]{dueDate, ship, shipyard};
        return (AIRepairTask)((Object)this.context.getBean("aIRepairTask", args));
    }

    public TimedTask getWeeklyLoanerCheck() {
        return (TimedTask)this.context.getBean(WeeklyLoanerCheckTask.class);
    }

    public TimedTask getWeeklyCityCheck() {
        return (TimedTask)this.context.getBean(WeeklyCityCheckTask.class);
    }

    public MarriageOfferTask getMarriageOfferTask(IAIPlayer player, MarriageBrokerAnnouncementState state, DateTime deadLine) {
        return (MarriageOfferTask)((Object)this.context.getBean("marriageOfferTask", new Object[]{player, state, deadLine}));
    }

    public PlageTimedTask getPlagueTask(int popultation, int duration, ICity city, DateTime plagueStart, DateTime plagueEnd) {
        return (PlageTimedTask)((Object)this.context.getBean("plageTimedTask", new Object[]{popultation, duration, city, plagueStart, plagueEnd}));
    }

    public ChurchUpgradeTimedTask getChurchUpgradeTask(IChurch church, DateTime deadline) {
        return (ChurchUpgradeTimedTask)((Object)this.context.getBean("churchUpgradeTimedTask", new Object[]{church, deadline}));
    }

    public LoanerCollectMoneyAfterAuctionTimedTask getLoanerCollectMoneyAfterAuctionTask(IDebt debt, DateTime deadline) {
        return (LoanerCollectMoneyAfterAuctionTimedTask)((Object)this.context.getBean("loanerCollectMoneyAfterAuctionTimedTask", new Object[]{debt, deadline}));
    }

    public LoanerCollectMoneyWithoutAuctionTimedTask getLoanerCollectMoneyTask(IDebt debt, IPlayer debitor, DateTime deadline) {
        return (LoanerCollectMoneyWithoutAuctionTimedTask)((Object)this.context.getBean("loanerCollectMoneyWithoutAuctionTimedTask", new Object[]{debt, debitor, deadline}));
    }

    public MarriageOfferDeclinedTimedTask getMarriageOfferDeclinedTask(IPlayer player) {
        return (MarriageOfferDeclinedTimedTask)((Object)this.context.getBean("marriageOfferDeclinedTimedTask", new Object[]{player}));
    }
}

