/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.StateFactory;
import ch.sahits.game.openpatrician.engine.event.task.ServerSideTaskFactory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.LoanerList;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class WeeklyLoanerCheckTask
extends TimedTask {
    @Autowired
    private Date date;
    @Autowired
    @XStreamOmitField
    private StateFactory stateFactory;
    @Autowired
    private LoanerList loaners;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    @XStreamOmitField
    private ServerSideTaskFactory taskFactory;

    @PostConstruct
    private void initialize() {
        this.setExecutionTime(this.getScheduledDateWeeklyUpdate());
    }

    private DateTime getScheduledDateWeeklyUpdate() {
        return this.date.getCurrentDate().plusWeeks(1);
    }

    public void run() {
        this.handleWeeklyUpdates();
    }

    private void handleWeeklyUpdates() {
        try {
            for (ILoaner loaner : this.loaners) {
                this.stateFactory.updateLoanerRequestsAndLoans(loaner);
            }
        }
        finally {
            this.scheduleNextWeekUpdate();
        }
    }

    private void scheduleNextWeekUpdate() {
        this.taskList.add(this.taskFactory.getWeeklyLoanerCheck());
    }
}

