/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.event.data.ClockTickDayChange;
import ch.sahits.game.event.data.ShipArrivesAtDestinationEvent;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.land.city.ReputationCalculator;
import ch.sahits.game.openpatrician.engine.player.HumanPlayerEngine;
import ch.sahits.game.openpatrician.model.IBalanceSheet;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.PlayerList;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.building.ISteward;
import ch.sahits.game.openpatrician.model.building.IStorage;
import ch.sahits.game.openpatrician.model.building.ITownHouse;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.IWorkShop;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.personal.IReputation;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.sea.TravellingVessels;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.spring.DependentPropertyInitializer;
import ch.sahits.game.openpatrician.util.spring.DependentValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class PlayerEngine
extends AbstractEngine {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @DependentValue(value="sailor.cost.per.day")
    private double dailySailorCost = 0.5;
    @Autowired
    private PlayerList players;
    @Autowired
    private HumanPlayerEngine humanPlayerEngine;
    @Autowired
    private IMap map;
    @Autowired
    private ReputationCalculator repCalc;
    @Autowired
    private TravellingVessels vessels;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private DependentPropertyInitializer propertyInitializer;

    @PostConstruct
    private void init() {
        try {
            this.propertyInitializer.initializeAnnotatedFields((Object)this);
        }
        catch (IllegalAccessException e) {
            this.logger.warn("Failed to initialize DependentValue annotated fields");
        }
        this.clientServerEventBus.register((Object)this);
        this.timerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
        this.timerEventBus.unregister((Object)this);
    }

    @Subscribe
    public void handleDailyUpdate(ClockTickDayChange event) {
        this.dailyUpdateBalanceSheet();
        this.updateCompanyValue();
    }

    @Subscribe
    public void handleWeeklyUpdate(ClockTickDayChange event) {
        for (IPlayer player : this.players) {
            for (ICity city : this.map.getCities()) {
                try {
                    IReputation reputation = city.getReputation(player);
                    int wareReputation = this.repCalc.calculateWareReputation(city, player);
                    reputation.addWareReputation(wareReputation);
                }
                catch (RuntimeException e) {
                    this.logger.error("Failed to update reputation for " + player.getName() + " " + player.getLastName() + " in " + city.getName(), (Throwable)e);
                }
            }
        }
    }

    @VisibleForTesting
    void updateCompanyValue() {
        for (IPlayer player : this.players) {
            ICompany company = player.getCompany();
            long newCompanyValue = company.getCash();
            List ships = player.getFleet();
            for (IShip ship : ships) {
                newCompanyValue += (long)ship.getValue();
                Set loaded = ship.getLoadedWares();
                for (IWare ware : loaded) {
                    AmountablePrice ap = ship.getWare(ware);
                    newCompanyValue += (long)(ap.getAVGPrice() * ap.getAmount());
                }
            }
            for (ICity city : this.map.getCities()) {
                List buildings = player.findBuildings(city);
                for (IBuilding building : buildings) {
                    newCompanyValue += (long)building.getValue();
                    if (!(building instanceof ITradingOffice)) continue;
                    ITradingOffice office = (ITradingOffice)building;
                    for (EWare ware : EWare.values()) {
                        AmountablePrice ap = office.getWare((IWare)ware);
                        newCompanyValue += (long)(ap.getAVGPrice() * ap.getAmount());
                    }
                }
            }
            company.setCompanyValue(newCompanyValue);
        }
    }

    @Override
    public List<AbstractEngine> getChildren() {
        ArrayList<AbstractEngine> engines = new ArrayList<AbstractEngine>();
        engines.add(this.humanPlayerEngine);
        return engines;
    }

    private void dailyUpdateBalanceSheet() {
        List cities = this.map.getCities();
        for (IPlayer player : this.players) {
            long sum = 0L;
            int stewardCosts = 0;
            int rentalIncome = 0;
            int wageCosts = 0;
            int otherCosts = 0;
            for (ICity city : cities) {
                Object building3;
                Optional optOffice = player.findTradingOffice(city);
                if (!optOffice.isPresent()) continue;
                ITradingOffice office = (ITradingOffice)optOffice.get();
                Optional steward = office.getSteward();
                if (steward.isPresent()) {
                    sum += (long)(stewardCosts -= (int)Math.rint((double)((ISteward)steward.get()).getSalary() / 7.0));
                }
                List townHouses = player.findBuildings(city, ITownHouse.class);
                for (IBuilding building2 : townHouses) {
                    sum += (long)(rentalIncome += ((ITownHouse)building2).computeRentalIncome());
                }
                List workshops = player.findBuildings(city, IWorkShop.class);
                IStorage storage = office.getStorage();
                for (Object building3 : workshops) {
                    int workers = ((IWorkShop)building3).getWorkers();
                    int salaryPerWorker = ((IWorkShop)building3).getSalaryPerWorker();
                    wageCosts -= (int)Math.rint((double)(salaryPerWorker * workers) / 7.0);
                }
                wageCosts -= storage.guardCostsPerDayBinding().get();
                List fleet = player.getFleet();
                building3 = fleet.iterator();
                while (building3.hasNext()) {
                    IShip ship = (IShip)building3.next();
                    double sailorSalary = (double)ship.getNumberOfSailors() * this.dailySailorCost;
                    wageCosts = (int)((double)wageCosts - sailorSalary);
                    if (ship.getCaptian().isPresent()) {
                        wageCosts -= ((ICaptain)ship.getCaptian().get()).getSalary();
                        continue;
                    }
                    if (!(sailorSalary > 0.0)) continue;
                    wageCosts = (int)((double)wageCosts - this.dailySailorCost);
                }
                sum += (long)wageCosts;
                player.getCompany().updateCash(sum += (long)(otherCosts -= storage.costsPerDayBinding().get()));
                if (!(player instanceof IHumanPlayer)) continue;
                Optional optMainOffice = player.findTradingOffice(player.getHometown());
                Preconditions.checkArgument((boolean)optMainOffice.isPresent(), (Object)"There must be a trading office in the hometown.");
                IBalanceSheet balanceSheet = ((ITradingOffice)optMainOffice.get()).getCurrentWeek();
                balanceSheet.updateRentalIncome(rentalIncome);
                balanceSheet.updateStewardCosts(stewardCosts);
                balanceSheet.updateSalaries(wageCosts);
                balanceSheet.updateOtherExpensesRegular(otherCosts);
            }
        }
    }

    @Subscribe
    public void handleShipReachesDestination(ShipArrivesAtDestinationEvent event) {
        INavigableVessel vessel = event.getShip();
        this.vessels.remove(vessel);
    }
}

