/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.clientserverinterface.model.factory.ShipFactory;
import ch.sahits.game.openpatrician.engine.player.CollectWaresMissionData;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.city.IShipDueDate;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.city.Shipyards;
import ch.sahits.game.openpatrician.model.player.IAIConstructionSelectionStrategy;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.ISpecialMission;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseShipConstructionSelectionStrategy
implements IAIConstructionSelectionStrategy {
    private int constructMaxShips = 1;
    @Autowired
    private ShipFactory shipFactory;
    @Autowired
    private Shipyards shipyards;
    private final int minCash;
    private final int maxFeetSize;
    private final int maxTotalCargoCapacity;

    protected BaseShipConstructionSelectionStrategy(int minCash, int maxFeetSize, int maxTotalCargoCapacity) {
        this.minCash = minCash;
        this.maxFeetSize = maxFeetSize;
        this.maxTotalCargoCapacity = maxTotalCargoCapacity;
    }

    public boolean shouldOrderNewConstruction(IAIPlayer player) {
        ICompany company = player.getCompany();
        if (company.getCash() < (long)this.minCash) {
            return false;
        }
        List fleet = player.getFleet();
        if (fleet.size() >= this.maxFeetSize) {
            return false;
        }
        int totalSize = this.getFleetCapacity(fleet);
        if (totalSize >= this.maxTotalCargoCapacity) {
            return false;
        }
        int nbConstuctionOrders = 0;
        for (Map.Entry entry : this.shipyards) {
            IShipyard shipyard = (IShipyard)entry.getValue();
            List orders = shipyard.getShipBuildingList();
            for (IShipDueDate order : orders) {
                if (order.getShip().getOwner().equals(player)) {
                    ++nbConstuctionOrders;
                }
                if (nbConstuctionOrders < this.constructMaxShips) continue;
                return false;
            }
        }
        return true;
    }

    protected int getFleetCapacity(List<IShip> fleet) {
        int totalSize = 0;
        for (IShip ship : fleet) {
            totalSize += ship.getCapacity();
        }
        return totalSize;
    }

    protected Optional<INavigableVessel> selectCollectingVessel(IAIPlayer player, EShipType shipType) {
        int totalAmountInBarrel = 0;
        for (EWare ware : EWare.values()) {
            int amount = this.shipFactory.getConstructionAmount(shipType, ware);
            totalAmountInBarrel += amount * ware.getSizeAsBarrels();
        }
        for (INavigableVessel vessel : player.getSelectableVessels()) {
            if (vessel.getCapacity() <= totalAmountInBarrel || !this.isVesselEligibleForCollecting(player, vessel)) continue;
            return Optional.of(vessel);
        }
        if (this.isVesselEligibleForCollecting(player, (INavigableVessel)player.getSelectableVessels().get(0))) {
            return Optional.of(player.getSelectableVessels().get(0));
        }
        return Optional.empty();
    }

    private boolean isVesselEligibleForCollecting(IAIPlayer player, INavigableVessel vessel) {
        return !(player.getTradeMission(vessel) instanceof CollectWaresMissionData) && !(player.getTradeMission(vessel) instanceof ISpecialMission);
    }

    protected void setConstructMaxShips(int constructMaxShips) {
        this.constructMaxShips = constructMaxShips;
    }

    protected int getMinCash() {
        return this.minCash;
    }

    protected int getMaxFeetSize() {
        return this.maxFeetSize;
    }

    protected int getMaxTotalCargoCapacity() {
        return this.maxTotalCargoCapacity;
    }
}

