/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.product.ISpecialMission;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class BlockadeStrategy {
    @Autowired
    private ShipService shipService;

    public Optional<IShip> selectShip(IAIPlayer player) {
        List vessels = player.getSelectableVessels();
        IShip strongestShip = null;
        int strongest = 0;
        for (INavigableVessel vessel : vessels) {
            if (!(vessel instanceof IShip) || player.getTradeMission(vessel) instanceof ISpecialMission) continue;
            int strength = this.shipService.calculateShipsWeaponsStrength(vessel);
            if (strongestShip == null) {
                strongestShip = (IShip)vessel;
                strongest = strength;
                continue;
            }
            if (strength <= strongest) continue;
            strongestShip = (IShip)vessel;
            strongest = strength;
        }
        return Optional.ofNullable(strongestShip);
    }
}

