/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.engine.player.strategy.BasePlayerTradeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.EAITradeStrategyType;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatedCheckedBuyTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatesSellTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AmountBasedAggregatedDumpTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.CheckForRepairTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.CheckHireCaptainTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.GuildJoinTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.HireSailorsStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.PayBackLoanTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TakeLoanTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TravelToTradeStep;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.IShipEntersPortEvent;
import ch.sahits.game.openpatrician.model.player.ICityProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.player.IProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.sea.BlockadeState;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.util.Pair;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class CheapProductionTradeStrategy
extends BasePlayerTradeStrategy {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @XStreamOmitField
    private ShipService shipService;
    @Value(value="${aiplayer.money.low}")
    private int lowMoney = 2000;
    @Autowired
    @XStreamOmitField
    private MapService mapService;
    @Autowired
    private BlockadeState blockade;

    public CheapProductionTradeStrategy() {
        this.tradeStrategyType = EAITradeStrategyType.CHEAP_PRODUCTION;
    }

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void destroy() {
        this.clientServerEventBus.unregister((Object)this);
    }

    public void initialzeTradeCycle(IAIPlayer player, INavigableVessel vessel) {
        Optional optCity = this.shipService.findCity(vessel);
        if (!optCity.isPresent()) {
            this.logger.debug("The vessel {} is not in any city but {}", new Object[]{vessel.getName(), vessel.getLocation()});
        }
        List<IWare> loadedWares = this.getLoadedWares(vessel);
        ICity city = (ICity)optCity.get();
        if (!loadedWares.isEmpty()) {
            AggregatesSellTradeStep sellStep = this.createAggregatedSellStep(vessel, city, loadedWares);
            this.append(player, vessel, sellStep);
            int maxAmount = vessel.getSize() / 5;
            AmountBasedAggregatedDumpTradeStep sellStep1 = this.createConditionalAggregatedDumpStep(vessel, city, loadedWares, maxAmount);
            this.append(player, vessel, sellStep1);
        }
        PayBackLoanTradeStep payBackLoan = this.createPaybackLoanStep(player, city);
        this.append(player, vessel, payBackLoan);
        CheckHireCaptainTradeStep hireCaptain = this.createHireCaptain(vessel, city, player);
        this.append(player, vessel, hireCaptain);
        GuildJoinTradeStep joinTradeStep = this.createJoinGuildTradeStep(vessel, city, player);
        this.append(player, vessel, joinTradeStep);
        TakeLoanTradeStep takeLoanStep = this.createCheckAndTakeLoanStep(player, city);
        this.append(player, vessel, takeLoanStep);
        Optional<IWare> ware = this.findWareToBuy(city, player);
        if (!ware.isPresent()) {
            this.moveToNextStopEmpty(player, vessel, city);
        } else {
            ArrayList<IWare> buyWare = new ArrayList<IWare>();
            buyWare.add(ware.get());
            Optional<ICity> nextStop = this.findNearestCityWithNeed(city, player, ware.get(), vessel, city);
            if (nextStop.isPresent()) {
                AggregatedCheckedBuyTradeStep buyStepHometown = this.createAggregatedCheckedBuyTradeStep(vessel, city, buyWare);
                this.append(player, vessel, buyStepHometown);
                CheckForRepairTradeStep repairStep = this.createCheckRepairStep(vessel, city);
                this.append(player, vessel, repairStep);
                HireSailorsStep hireSailors = this.createHireSailorStep(vessel, city);
                this.append(player, vessel, hireSailors);
                TravelToTradeStep travelTo = this.createTravelToStep(vessel, nextStop.get());
                this.append(player, vessel, travelTo);
            } else {
                this.moveToNextStopEmpty(player, vessel, city);
            }
        }
    }

    private void moveToNextStopEmpty(IAIPlayer player, INavigableVessel vessel, ICity city) {
        CheckForRepairTradeStep repairStep = this.createCheckRepairStep(vessel, city);
        this.append(player, vessel, repairStep);
        ICity nextStop = this.mapService.findNearestNonBlockadedCity(city.getCoordinates());
        HireSailorsStep hireSailors = this.createHireSailorStep(vessel, city);
        this.append(player, vessel, hireSailors);
        TravelToTradeStep travelTo = this.createTravelToStep(vessel, nextStop);
        this.append(player, vessel, travelTo);
    }

    private Optional<ICity> findNearestCityWithNeed(ICity city, IAIPlayer player, IWare ware, INavigableVessel vessel, ICity excludeCity) {
        IProductionConsumptionKnowledge knowledge = player.getProductionAndConsumptionKnowledge();
        List cityList = this.mapService.getNonBlockadedCitiesOrderedByDistance(city, vessel);
        cityList.remove(excludeCity);
        for (ICity iCity : cityList) {
            ICityProductionConsumptionKnowledge cityProduction = knowledge.getKnowlege(iCity);
            List<Pair<IWare, Number>> mostNeeded = this.getMostNeededWares(cityProduction);
            for (Pair<IWare, Number> pair : mostNeeded) {
                if (!((IWare)pair.getKey()).equals(ware) || ((Number)pair.getValue()).intValue() >= 10) continue;
                return Optional.of(iCity);
            }
        }
        return Optional.empty();
    }

    private Optional<IWare> findWareToBuy(ICity city, IAIPlayer player) {
        IWare[] wares = city.getEffectiveProduction();
        IProductionConsumptionKnowledge knowledge = player.getProductionAndConsumptionKnowledge();
        ICityProductionConsumptionKnowledge knowledgeCurrentTown = knowledge.getKnowlege(city);
        IWare ware = null;
        int amount = 0;
        for (IWare good : wares) {
            int storedAmount = knowledgeCurrentTown.getStoredAmount(good);
            if (storedAmount <= 0 || knowledgeCurrentTown.getProductionAmount(good) <= knowledgeCurrentTown.getConsumptionAmount(good) || storedAmount <= amount) continue;
            ware = good;
            amount = storedAmount;
        }
        return Optional.ofNullable(ware);
    }

    public void handleShipArrivesInPort(IShipEntersPortEvent event) {
        INavigableVessel vessel = event.getShip();
        IAIPlayer player = (IAIPlayer)vessel.getOwner();
        Preconditions.checkArgument((!this.hasMoreTradeSteps(player, vessel) ? 1 : 0) != 0, (Object)"There must not be any more trade steps defined.");
        ICity city = event.getCity();
        Preconditions.checkArgument((boolean)city.getCoordinates().equals((Object)vessel.getLocation()), (Object)("The vessel " + vessel.getName() + " actually is not in city " + city.getName()));
        this.initialzeTradeCycle(player, vessel);
        this.executeTradeSteps(player, vessel);
    }
}

