/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.ShipFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.engine.player.CollectConstructionWaresMissionData;
import ch.sahits.game.openpatrician.engine.player.CollectWaresMissionData;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectionWaresStrategy;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public abstract class CollectConstructionWareStrategy
extends CollectionWaresStrategy {
    private final EShipType constructionType;
    @Autowired
    private ShipFactory shipFactory;
    @Autowired
    private TradeService tradeService;

    public CollectConstructionWareStrategy(EShipType constructionType) {
        this.constructionType = constructionType;
    }

    @Override
    protected CollectWaresMissionData createMissionData(IAIPlayer player) {
        ICity where = this.getConstructionCity(player);
        CollectConstructionWaresMissionData missionData = new CollectConstructionWaresMissionData();
        missionData.setCity(where);
        missionData.setShipType(this.constructionType);
        for (EWare ware : EWare.values()) {
            int amount = this.shipFactory.getConstructionAmount(this.constructionType, ware);
            if (amount <= 0) continue;
            Optional optOffice = player.findTradingOffice(where);
            if (optOffice.isPresent()) {
                this.tradeService.buyFromCityToStorage((ITradingOffice)optOffice.get(), (IPlayer)player, where, (IWare)ware, amount);
                amount = Math.max(0, amount - ((ITradingOffice)optOffice.get()).getWare((IWare)ware).getAmount());
            }
            missionData.require((IWare)ware, amount);
        }
        return missionData;
    }

    protected abstract ICity getConstructionCity(IAIPlayer var1);

    @Override
    protected boolean checkAllWaresCollected(ICity city, INavigableVessel vessel, CollectWaresMissionData tradeMission, Optional<ITradingOffice> tradingOffice) {
        boolean haveEverything = true;
        for (EWare ware : EWare.values()) {
            int amount = this.shipFactory.getConstructionAmount(((CollectConstructionWaresMissionData)tradeMission).getShipType(), ware);
            if (amount <= 0) continue;
            int availableAmount = 0;
            if (tradingOffice.isPresent()) {
                availableAmount += tradingOffice.get().getWare((IWare)ware).getAmount();
            }
            availableAmount += vessel.getWare((IWare)ware).getAmount();
            if ((availableAmount += city.getWare((IWare)ware).getAmount()) >= amount) continue;
            haveEverything = false;
            break;
        }
        return haveEverything;
    }
}

