/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.engine.player.strategy.BaseShipConstructionSelectionStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionHometownCogWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionHometownCrayerWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionHometownHolkWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionHometownSnaikkaWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionWareStrategy;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class HometownBiggestShipConstructionSelectionStrategy
extends BaseShipConstructionSelectionStrategy {
    @Autowired
    private ApplicationContext context;

    public HometownBiggestShipConstructionSelectionStrategy() {
        super(100000, 50, 15000);
    }

    public EShipType shouldBuildShipType(IAIPlayer player) {
        int maxTotalCargoCapacity;
        ICity where = this.getBuildLocation(player);
        ArrayList<EShipType> shipTypes = new ArrayList<EShipType>(Arrays.asList(where.getCityState().getShipyardState().getBuildableShipTypes()));
        int fleetCapacity = this.getFleetCapacity(player.getFleet());
        double capacityOfMaxPercent = (double)fleetCapacity * 1.0 / (double)(maxTotalCargoCapacity = this.getMaxTotalCargoCapacity());
        if (capacityOfMaxPercent >= 0.7) {
            return this.biggestShipType(shipTypes);
        }
        if (capacityOfMaxPercent <= 0.3) {
            shipTypes.remove(EShipType.HOLK);
        }
        if (capacityOfMaxPercent <= 0.1) {
            shipTypes.remove(EShipType.COG);
        }
        if (capacityOfMaxPercent <= 0.05) {
            shipTypes.remove(EShipType.CRAYER);
        }
        return this.biggestShipType(shipTypes);
    }

    private EShipType biggestShipType(List<EShipType> shipTypes) {
        EShipType[] sizedTypes;
        for (EShipType type : sizedTypes = new EShipType[]{EShipType.HOLK, EShipType.COG, EShipType.CRAYER, EShipType.SNAIKKA}) {
            if (!shipTypes.contains(type)) continue;
            return type;
        }
        return null;
    }

    public ICity getBuildLocation(IAIPlayer player) {
        return player.getHometown();
    }

    public void initShipConstruction(IAIPlayer player, ICity buildLocation, EShipType shipType) {
        CollectConstructionWareStrategy strategy = null;
        switch (shipType) {
            case HOLK: {
                strategy = (CollectConstructionWareStrategy)this.context.getBean(CollectConstructionHometownHolkWareStrategy.class);
                break;
            }
            case COG: {
                strategy = (CollectConstructionWareStrategy)this.context.getBean(CollectConstructionHometownCogWareStrategy.class);
                break;
            }
            case CRAYER: {
                strategy = (CollectConstructionWareStrategy)this.context.getBean(CollectConstructionHometownCrayerWareStrategy.class);
                break;
            }
            case SNAIKKA: {
                strategy = (CollectConstructionWareStrategy)this.context.getBean(CollectConstructionHometownSnaikkaWareStrategy.class);
            }
        }
        Optional<INavigableVessel> vessel = this.selectCollectingVessel(player, shipType);
        if (vessel.isPresent()) {
            strategy.initialzeTradeCycle(player, vessel.get());
        }
    }
}

