/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
public abstract class AbstractBuyTradeStep
implements ITradeStep {
    private ICity city;
    private IWare ware;
    private INavigableVessel vessel;
    private boolean executeNext = true;
    @Autowired
    @XStreamOmitField
    private ComputablePriceV2 computablePrice;

    protected boolean buyWare(int availableAmount, IPlayer player, ICompany company, int affordableAmount) {
        if (affordableAmount > 0) {
            int buyPrice = this.computablePrice.buyPrice((ITradable)this.ware, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(availableAmount), (IntegerBinding)new ConstantIntegerBinding(affordableAmount));
            company.updateCash((long)(-buyPrice * affordableAmount));
            this.city.move(this.ware, -affordableAmount, (ICitizen)player);
            this.vessel.load(this.ware, affordableAmount, buyPrice);
        }
        return this.executeNext;
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    protected ICity getCity() {
        return this.city;
    }

    public void setWare(IWare ware) {
        this.ware = ware;
    }

    public IWare getWare() {
        return this.ware;
    }

    public void setVessel(INavigableVessel vessel) {
        this.vessel = vessel;
    }

    protected INavigableVessel getVessel() {
        return this.vessel;
    }

    public void setExecuteNext(boolean executeNext) {
        this.executeNext = executeNext;
    }
}

