/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.event.data.ai.HireSailorEvent;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.ISailorState;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.ship.IGroupableVessel;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class HireSailorsStep
implements ITradeStep {
    private INavigableVessel ship;
    private ICity city;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private Date date;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @XStreamOmitField
    private ShipService shipService;

    public boolean execute() {
        Preconditions.checkArgument((boolean)this.city.getCoordinates().equals((Object)this.ship.getLocation()), (String)("Ship " + this.ship.getName() + " is not in the city {} but at {}"), (Object[])new Object[]{this.city.getName(), this.ship.getLocation()});
        ISailorState sailorState = this.city.getCityState().getTavernState().getSailors();
        int onShip = this.ship.getNumberOfSailors();
        int neededSailors = this.shipService.getMinNumberOfSailors(this.ship);
        if (onShip >= neededSailors) {
            return true;
        }
        int nbToHire = neededSailors - onShip;
        int inTavern = sailorState.getNumberOfSailors();
        if (inTavern >= nbToHire) {
            if (this.ship instanceof IShip) {
                for (int i = 0; i < nbToHire; ++i) {
                    sailorState.hire();
                }
                ((IShip)this.ship).setNumberOfSailors(onShip + nbToHire);
                return true;
            }
            IGroupableVessel group = (IGroupableVessel)this.ship;
            for (IShip vessel : group.getShips()) {
                onShip = vessel.getNumberOfSailors();
                neededSailors = vessel.getMinNumberOfSailors();
                nbToHire = neededSailors - onShip;
                for (int i = 0; i < nbToHire; ++i) {
                    sailorState.hire();
                }
                vessel.setNumberOfSailors(onShip + nbToHire);
            }
            return true;
        }
        if (this.ship instanceof IShip) {
            for (int i = 0; i < inTavern; ++i) {
                sailorState.hire();
            }
            ((IShip)this.ship).setNumberOfSailors(onShip + inTavern);
        } else {
            IGroupableVessel group = (IGroupableVessel)this.ship;
            for (IShip vessel : group.getShips()) {
                onShip = vessel.getNumberOfSailors();
                neededSailors = vessel.getMinNumberOfSailors();
                nbToHire = Math.min(neededSailors - onShip, sailorState.getNumberOfSailors());
                for (int i = 0; i < nbToHire; ++i) {
                    sailorState.hire();
                }
                vessel.setNumberOfSailors(onShip + nbToHire);
            }
        }
        DateTime currentDate = this.date.getCurrentDate();
        final DateTime tomorrow = currentDate.plusDays(1);
        TimedTask task = new TimedTask(){
            {
                this.setExecutionTime(tomorrow);
            }

            public void run() {
                HireSailorsStep.this.clientServerEventBus.post((Object)new HireSailorEvent(HireSailorsStep.this.ship, HireSailorsStep.this.city));
            }
        };
        this.taskList.add(task);
        return false;
    }

    public String toString() {
        return "HireSailorsStep{" + this.ship.getName() + " in " + this.city.getName() + "needs " + this.shipService.getMinNumberOfSailors(this.ship) + " and has currently " + this.ship.getNumberOfSailors() + '}';
    }

    public void setShip(INavigableVessel ship) {
        this.ship = ship;
    }

    public void setCity(ICity city) {
        this.city = city;
    }
}

