/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.service.LoanerService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class PayBackLoanTradeStep
implements ITradeStep {
    private ICity city;
    private IAIPlayer player;
    @Value(value="${loan.payback.limit}")
    private int cashLimit = 10000;
    @Autowired
    @XStreamOmitField
    private LoanerService loanerService;

    public boolean execute() {
        ICompany company = this.player.getCompany();
        if (company.getCash() > (long)this.cashLimit) {
            ILoaner loaner = this.loanerService.findLoaner(this.city);
            List debts = this.loanerService.findDebts(loaner, (IPlayer)this.player);
            for (IDebt debt : debts) {
                int debtTotal = this.loanerService.calculatePaybacksum(debt);
                debt.getCreditor().receiveSum((long)debtTotal);
                company.updateCash((long)(-debtTotal));
                loaner.getDebts().remove(debt);
                if (company.getCash() >= (long)this.cashLimit) continue;
                break;
            }
        }
        return true;
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    public void setPlayer(IAIPlayer player) {
        this.player = player;
    }
}

