/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class SellTradeStep
implements ITradeStep {
    private ICity city;
    private IWare ware;
    private INavigableVessel vessel;
    @Autowired
    @XStreamOmitField
    private ComputablePriceV2 computablePrice;
    private boolean executeNext = true;

    public boolean execute() {
        int availableAmount = this.city.getWare(this.ware).getAmount();
        int maxSellAmount = this.vessel.getWare(this.ware).getAmount();
        int minSellPrice = this.vessel.getWare(this.ware).getAVGPrice();
        int sellAmount = this.computablePrice.calculateSellAmount((ITradable)this.ware, availableAmount, minSellPrice, maxSellAmount);
        if (sellAmount > 0) {
            int sellPrice = this.computablePrice.sellPrice((ITradable)this.ware, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(availableAmount), (IntegerBinding)new ConstantIntegerBinding(sellAmount));
            IAIPlayer player = (IAIPlayer)this.vessel.getOwner();
            ICompany company = player.getCompany();
            company.updateCash((long)(sellPrice * sellAmount));
            this.city.move(this.ware, sellAmount, (ICitizen)player);
            this.vessel.load(this.ware, sellAmount, sellPrice);
        }
        return this.executeNext;
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    public void setWare(IWare ware) {
        this.ware = ware;
    }

    public IWare getWare() {
        return this.ware;
    }

    public void setVessel(INavigableVessel vessel) {
        this.vessel = vessel;
    }

    public void setExecuteNext(boolean executeNext) {
        this.executeNext = executeNext;
    }
}

