/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.engine.sea.ESeaFightType;
import ch.sahits.game.openpatrician.engine.sea.SeaFightContext;
import ch.sahits.game.openpatrician.model.sea.IBlockade;
import ch.sahits.game.openpatrician.model.ship.IShip;
import java.util.ArrayList;
import java.util.List;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class BlockadeSeafightContext
extends SeaFightContext {
    private final IBlockade blockade;
    @ListType(value=IShip.class)
    private List<IShip> capturedShips = new ArrayList<IShip>();

    public BlockadeSeafightContext(IBlockade blockade) {
        super(ESeaFightType.BLOCKADE);
        this.blockade = blockade;
    }

    public void addCapturedShip(IShip ship) {
        this.capturedShips.add(ship);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockadeSeafightContext)) {
            return false;
        }
        BlockadeSeafightContext other = (BlockadeSeafightContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IBlockade this$blockade = this.getBlockade();
        IBlockade other$blockade = other.getBlockade();
        if (this$blockade == null ? other$blockade != null : !this$blockade.equals(other$blockade)) {
            return false;
        }
        List<IShip> this$capturedShips = this.getCapturedShips();
        List<IShip> other$capturedShips = other.getCapturedShips();
        return !(this$capturedShips == null ? other$capturedShips != null : !((Object)this$capturedShips).equals(other$capturedShips));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BlockadeSeafightContext;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IBlockade $blockade = this.getBlockade();
        result = result * 59 + ($blockade == null ? 43 : $blockade.hashCode());
        List<IShip> $capturedShips = this.getCapturedShips();
        result = result * 59 + ($capturedShips == null ? 43 : ((Object)$capturedShips).hashCode());
        return result;
    }

    public IBlockade getBlockade() {
        return this.blockade;
    }

    public List<IShip> getCapturedShips() {
        return this.capturedShips;
    }
}

