/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea;

import ch.sahits.game.event.EGameStatusChange;
import ch.sahits.game.event.GameStateChange;
import ch.sahits.game.event.data.ShipPositionUpdateEvent;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.model.AIPlayerList;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.PlayerList;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.sea.ILocationTracker;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Interner;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@ClassCategory(value={EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class LocationTracker
implements ILocationTracker {
    @XStreamOmitField
    private static final Logger LOGGER = LogManager.getLogger(LocationTracker.class);
    @Autowired
    private IMap map;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="syncServerClientEventBus")
    @XStreamOmitField
    private EventBus syncServerClientEventBus;
    @Autowired
    @XStreamOmitField
    protected Interner<Point2D> pointInterner;
    @Autowired
    private AIPlayerList aiPlayers;
    @Autowired
    private PlayerList players;
    private Dimension2D mapDimension;
    private double segmentEdgeWidth;
    private double segmentEdgeHeigth;
    @ListType(value=INavigableVessel.class)
    private List<WeakReference<INavigableVessel>>[][] segments;

    @PostConstruct
    void initialize() {
        this.mapDimension = this.map.getDimension();
        this.updateSegmentSize(20);
        this.clientServerEventBus.register((Object)this);
        this.syncServerClientEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
        this.syncServerClientEventBus.unregister((Object)this);
    }

    public void updateSegmentSize(int nbShips) {
        int[] nbSegments = this.calculateRowsAndColumnsNeeded(nbShips / 2, this.mapDimension);
        this.segmentEdgeWidth = (this.mapDimension.getWidth() + 1.0) / (double)nbSegments[1];
        this.segmentEdgeHeigth = (this.mapDimension.getHeight() + 1.0) / (double)nbSegments[0];
        ArrayList registeredVessels = new ArrayList();
        if (this.segments != null) {
            List<WeakReference<INavigableVessel>>[][] listArray = this.segments;
            int n = listArray.length;
            for (int i = 0; i < n; ++i) {
                List<WeakReference<INavigableVessel>>[] outer;
                for (List<WeakReference<INavigableVessel>> inner : outer = listArray[i]) {
                    for (WeakReference<INavigableVessel> vessel : inner) {
                        if (vessel.get() == null) continue;
                        registeredVessels.add(vessel.get());
                    }
                }
            }
        }
        this.segments = new List[nbSegments[1]][nbSegments[0]];
        for (int i = 0; i < nbSegments[1]; ++i) {
            for (int j = 0; j < nbSegments[0]; ++j) {
                this.segments[i][j] = new ArrayList<WeakReference<INavigableVessel>>();
            }
        }
        for (INavigableVessel registeredVessel : registeredVessels) {
            this.add(registeredVessel);
        }
    }

    @VisibleForTesting
    int[] calculateIndices(Point2D location) {
        int indexX = (int)Math.max(Math.floor(location.getX() / this.segmentEdgeWidth), 0.0);
        int indexY = (int)Math.max(Math.floor(location.getY() / this.segmentEdgeHeigth), 0.0);
        return new int[]{indexX, indexY};
    }

    public void add(INavigableVessel ship) {
        int[] index = this.calculateIndices(ship.getLocation());
        this.segments[index[0]][index[1]].add(new WeakReference<INavigableVessel>(ship));
    }

    public void remove(INavigableVessel ship) {
        int[] index = this.calculateIndices(ship.getLocation());
        if (!this.segments[index[0]][index[1]].removeIf(wr -> ship.equals(wr.get()))) {
            LOGGER.warn("The ship {} could not be found and removed in segment {}", new Object[]{ship, index});
        }
    }

    public List<INavigableVessel> getShipsInSegment(Point2D location) {
        int[] index = this.calculateIndices(location);
        List<WeakReference<INavigableVessel>> references = this.segments[index[0]][index[1]];
        ArrayList<INavigableVessel> copyList = new ArrayList<INavigableVessel>();
        for (WeakReference<INavigableVessel> reference : references) {
            if (reference.get() == null) continue;
            copyList.add((INavigableVessel)reference.get());
        }
        return copyList;
    }

    public List<INavigableVessel> getShipsInSegments(Point2D location, int radius) {
        int[] index = this.calculateIndices(location);
        Point2D locationBefore = (Point2D)this.pointInterner.intern((Object)this.getPointOnMap(location.getX() - (double)radius, location.getY()));
        int[] indexBefore = this.calculateIndices(locationBefore);
        Point2D locationAfter = (Point2D)this.pointInterner.intern((Object)this.getPointOnMap(location.getX() + (double)radius, location.getY()));
        int[] indexAfter = this.calculateIndices(locationAfter);
        HashSet<INavigableVessel> set = new HashSet<INavigableVessel>();
        if (indexBefore != index) {
            set.addAll(this.getShipsInSegment(locationBefore));
        }
        set.addAll(this.getShipsInSegment(location));
        if (indexAfter != index) {
            set.addAll(this.getShipsInSegment(locationAfter));
        }
        return new ArrayList<INavigableVessel>(set);
    }

    private Point2D getPointOnMap(double x, double y) {
        double xx = Math.min(Math.max(0.0, x), this.mapDimension.getWidth());
        double yy = Math.min(Math.max(0.0, y), this.mapDimension.getHeight());
        return new Point2D(xx, yy);
    }

    @Subscribe
    public void handleShipMove(ShipPositionUpdateEvent event) {
        int[] newIndex;
        int[] oldIndex;
        if (!(event.getFromLocation().getX() == event.getToLocation().getX() && event.getFromLocation().getY() == event.getToLocation().getY() || Arrays.equals(oldIndex = this.calculateIndices(event.getFromLocation()), newIndex = this.calculateIndices(event.getToLocation())))) {
            this.segments[oldIndex[0]][oldIndex[1]].removeIf(wr -> event.getShip().equals(wr.get()));
            this.segments[newIndex[0]][newIndex[1]].add(new WeakReference<INavigableVessel>(event.getShip()));
        }
    }

    @VisibleForTesting
    int[] calculateRowsAndColumnsNeeded(int numberOfImages, Dimension2D containerSize) {
        int colsAttempt = 0;
        int rowsAttempt = 0;
        int containerArea = (int)Math.rint(containerSize.getHeight() * containerSize.getWidth());
        float singleCellArea = containerArea / numberOfImages;
        double cellSideLength = Math.sqrt(singleCellArea);
        colsAttempt = (int)Math.floor(containerSize.getWidth() / cellSideLength);
        if (colsAttempt * (rowsAttempt = (int)Math.floor(containerSize.getHeight() / cellSideLength)) >= numberOfImages) {
            return new int[]{rowsAttempt, colsAttempt};
        }
        if (containerSize.getHeight() <= containerSize.getWidth()) {
            colsAttempt = (int)Math.ceil(containerSize.getWidth() / cellSideLength);
            if (colsAttempt * (rowsAttempt = (int)Math.floor(containerSize.getHeight() / cellSideLength)) >= numberOfImages) {
                return new int[]{rowsAttempt, colsAttempt};
            }
            colsAttempt = (int)Math.floor(containerSize.getWidth() / cellSideLength);
            if (colsAttempt * (rowsAttempt = (int)Math.ceil(containerSize.getHeight() / cellSideLength)) >= numberOfImages) {
                return new int[]{rowsAttempt, colsAttempt};
            }
            colsAttempt = (int)Math.ceil(containerSize.getWidth() / cellSideLength);
            if (colsAttempt * (rowsAttempt = (int)Math.ceil(containerSize.getHeight() / cellSideLength)) >= numberOfImages) {
                return new int[]{rowsAttempt, colsAttempt};
            }
            throw new IllegalStateException("Could not calculate enough rows and columns");
        }
        colsAttempt = (int)Math.floor(containerSize.getWidth() / cellSideLength);
        if (colsAttempt * (rowsAttempt = (int)Math.ceil(containerSize.getHeight() / cellSideLength)) >= numberOfImages) {
            return new int[]{rowsAttempt, colsAttempt};
        }
        colsAttempt = (int)Math.ceil(containerSize.getWidth() / cellSideLength);
        if (colsAttempt * (rowsAttempt = (int)Math.floor(containerSize.getHeight() / cellSideLength)) >= numberOfImages) {
            return new int[]{rowsAttempt, colsAttempt};
        }
        colsAttempt = (int)Math.ceil(containerSize.getWidth() / cellSideLength);
        if (colsAttempt * (rowsAttempt = (int)Math.ceil(containerSize.getHeight() / cellSideLength)) >= numberOfImages) {
            return new int[]{rowsAttempt, colsAttempt};
        }
        throw new IllegalStateException("Could not calculate enough rows and columns");
    }

    @Subscribe
    public void handleGameLoad(GameStateChange gameStateChange) {
        if (gameStateChange.getStatusChange() == EGameStatusChange.GAME_LOADED) {
            int nbShips = 0;
            for (IAIPlayer player : this.aiPlayers) {
                nbShips += player.getFleet().size();
            }
            for (IAIPlayer player : this.players) {
                nbShips += player.getFleet().size();
            }
            this.updateSegmentSize(nbShips);
        }
    }
}

