/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.time;

import ch.sahits.game.event.data.ClockTick;
import ch.sahits.game.event.data.PeriodicalDailyUpdate;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.engine.time.IIndividualPeriodicalUpdater;
import ch.sahits.game.openpatrician.model.Date;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class IndividualPeriodicalUpdater
implements IIndividualPeriodicalUpdater {
    @Autowired
    private Date date;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @MapType(key=UpdateableObject.class, value=DateTime.class)
    private Map<UpdateableObject, DateTime> registeredUpdatableObjects = new HashMap<UpdateableObject, DateTime>();

    @PostConstruct
    private void register() {
        this.timerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.timerEventBus.unregister((Object)this);
    }

    @Override
    public void register(Object addresse, Object target) {
        DateTime now = this.date.getCurrentDate();
        UpdateableObject o = new UpdateableObject(target, addresse);
        DateTime nextUpdate = now.plusDays(1);
        this.registeredUpdatableObjects.put(o, nextUpdate);
    }

    @Override
    public void unregister(Object target) {
        Iterator<Map.Entry<UpdateableObject, DateTime>> iterator = this.registeredUpdatableObjects.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UpdateableObject, DateTime> entry = iterator.next();
            if (!entry.getKey().getTarget().equals(target)) continue;
            iterator.remove();
            break;
        }
    }

    @Override
    @Subscribe
    public void handleClockTick(ClockTick event) {
        DateTime now = this.date.getCurrentDate();
        for (Map.Entry<UpdateableObject, DateTime> entry : this.registeredUpdatableObjects.entrySet()) {
            if (!now.isAfter((ReadableInstant)entry.getValue())) continue;
            entry.setValue(now.plus(1L));
            PeriodicalDailyUpdate evt = new PeriodicalDailyUpdate(entry.getKey().getAddressee(), entry.getKey().getTarget());
            this.clientServerEventBus.post((Object)evt);
        }
    }

    Map<UpdateableObject, DateTime> getRegisteredUpdatableObjects() {
        return this.registeredUpdatableObjects;
    }

    static class UpdateableObject {
        private final Object target;
        private final Object addressee;

        @ConstructorProperties(value={"target", "addressee"})
        public UpdateableObject(Object target, Object addressee) {
            this.target = target;
            this.addressee = addressee;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateableObject)) {
                return false;
            }
            UpdateableObject other = (UpdateableObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$target = this.getTarget();
            Object other$target = other.getTarget();
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                return false;
            }
            Object this$addressee = this.getAddressee();
            Object other$addressee = other.getAddressee();
            return !(this$addressee == null ? other$addressee != null : !this$addressee.equals(other$addressee));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateableObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            Object $addressee = this.getAddressee();
            result = result * 59 + ($addressee == null ? 43 : $addressee.hashCode());
            return result;
        }

        public Object getTarget() {
            return this.target;
        }

        public Object getAddressee() {
            return this.addressee;
        }
    }
}

