package ch.sahits.game.openpatrician.engine.land.city.internal;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.city.impl.CityWall;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import org.joda.time.DateTime;

/**
 * Building task for the city wall.
 * This implementation does not yet take into account that there needs
 * to be a free building crew.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 05, 2015
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class CityWallBuildingTask extends TimedTask {
    private final CityWall cityWall;

    public CityWallBuildingTask(CityWall cityWall, DateTime exectutionTime) {
        this.cityWall = cityWall;
        setExecutionTime(exectutionTime);
    }

    @Override
    public void run() {
        cityWall.setUsedBricks(cityWall.getBoughtBricks()); // use all the bricks
    }
}
