package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.IWare;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

import java.util.List;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 21, 2016
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class TradeStepFactory {
    @Autowired
    private ApplicationContext context;

    /**
     * Create a trade step for buiyn wares into the trading office
     * @param office
     * @param city
     * @param waresToBuy
     * @return
     */
    public AggregatedBuyTradingOfficeTradeStep createAggregatedBuyTradingOfficeTradeStep(ITradingOffice office, ICity city, List<IWare> waresToBuy) {
        AggregatedBuyTradingOfficeTradeStep buyStepHometown = context.getBean(AggregatedBuyTradingOfficeTradeStep.class);
        buyStepHometown.setCity(city);
        buyStepHometown.setTradingOffice(office);
        for (IWare ware : waresToBuy) {
            int maxPrice = ware.getMaxBuyPriceOffensive();
            buyStepHometown.addBuyStep(ware, maxPrice);
        }
        return buyStepHometown;
    }
}
