/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine;

import ch.sahits.game.event.EGameStatusChange;
import ch.sahits.game.event.GameStateChange;
import ch.sahits.game.event.data.BuildingAuctionFinished;
import ch.sahits.game.event.data.BuildingNotAuctioned;
import ch.sahits.game.event.data.GraphInitialisationComplete;
import ch.sahits.game.event.data.PeriodicalTimeWeekEndUpdate;
import ch.sahits.game.event.data.ShipAuctionFinished;
import ch.sahits.game.event.data.ShipEntersPortEvent;
import ch.sahits.game.event.data.ShipNotAuctioned;
import ch.sahits.game.event.data.ShipyardOrderBuild;
import ch.sahits.game.event.data.ai.BlockadeShipRequestEvent;
import ch.sahits.game.event.data.ai.SpecialMissionFinishedEvent;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageBrokerAnnouncementState;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.clientserverinterface.service.StrategyHolderService;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.event.AIPlayerEngineState;
import ch.sahits.game.openpatrician.engine.event.EEventState;
import ch.sahits.game.openpatrician.engine.event.EventEngineState;
import ch.sahits.game.openpatrician.engine.event.task.MarriageOfferTask;
import ch.sahits.game.openpatrician.engine.event.task.ServerSideTaskFactory;
import ch.sahits.game.openpatrician.engine.land.city.ShipyardEngine;
import ch.sahits.game.openpatrician.engine.player.AITradeChecker;
import ch.sahits.game.openpatrician.engine.player.CollectConstructionWaresMissionData;
import ch.sahits.game.openpatrician.engine.player.IAIEventHandler;
import ch.sahits.game.openpatrician.engine.player.strategy.BlockadeStrategy;
import ch.sahits.game.openpatrician.engine.sea.SeafaringService;
import ch.sahits.game.openpatrician.model.AIPlayerList;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.event.IShipEntersPortEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.player.IAIConstructionSelectionStrategy;
import ch.sahits.game.openpatrician.model.player.IAIEventDecisionStrategy;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategy;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.model.player.IProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.product.IBlockadeMission;
import ch.sahits.game.openpatrician.model.product.ISpecialMission;
import ch.sahits.game.openpatrician.model.product.ITradeMissionData;
import ch.sahits.game.openpatrician.model.sea.BlockadeState;
import ch.sahits.game.openpatrician.model.sea.IBlockade;
import ch.sahits.game.openpatrician.model.sea.TravellingVessels;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.service.DisableProperties;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class AIPlayerEngine
extends AbstractEngine
implements IAIEventHandler {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private AIPlayerList players;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private BlockadeState blockadeState;
    @Autowired
    private BlockadeStrategy blockadeStrategy;
    @Autowired
    private SeafaringService seafaringService;
    @Autowired
    private Date date;
    @Autowired
    private MapService mapService;
    @Autowired
    private TravellingVessels vessels;
    @Autowired
    private AITradeChecker tradeChecker;
    @Autowired
    private ShipyardEngine shipyardEngine;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private ServerSideTaskFactory taskFactory;
    @Autowired
    private Random rnd;
    @Autowired
    private StrategyHolderService strategyHolderService;
    @Autowired
    private DisableProperties disableService;
    @Autowired
    private EventEngineState eventState;
    @Autowired
    private AIPlayerEngineState engineState;
    @ListType(value=ShipEntersPortEvent.class)
    private Queue<ShipEntersPortEvent> shipEntersPortEventQueue = new ConcurrentLinkedQueue<ShipEntersPortEvent>();

    @Override
    public List<AbstractEngine> getChildren() {
        return Collections.emptyList();
    }

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
        this.timerEventBus.register((Object)this);
    }

    private void initializeStrategyForVessel(IAIPlayer player, INavigableVessel ship) {
        IAITradeStrategy tradeStrategy = (IAITradeStrategy)player.getTradeStrategyType(ship).getStrategy();
        tradeStrategy.initialzeTradeCycle(player, ship);
        player.updateTradeWaitingStatus(ship, false);
    }

    @Subscribe
    public void handleBlockadeStart(BlockadeShipRequestEvent event) {
        Optional<IShip> optShip;
        IAIPlayer player = event.getPlayer();
        int requiredShips = event.getNumberOfShips();
        for (int i = 0; i < requiredShips && (optShip = this.blockadeStrategy.selectShip(player)).isPresent(); ++i) {
            IShip vessel = optShip.get();
            player.setTradeMission((INavigableVessel)vessel, (ITradeMissionData)new IBlockadeMission(){});
            this.seafaringService.travelTo((INavigableVessel)vessel, event.getAssemblyCity().getCoordinates());
        }
    }

    @Subscribe
    public void handleShipArrivesInCity(ShipEntersPortEvent event) {
        if (this.shipEntersPortEventQueue != null && !this.shipEntersPortEventQueue.isEmpty()) {
            this.shipEntersPortEventQueue.add(event);
            this.logger.info("Add ShipEntersPortEvent to queue.");
        } else {
            this.handleShipArrival(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleShipArrival(ShipEntersPortEvent event) {
        INavigableVessel vessel = event.getShip();
        ICity city = event.getCity();
        if (!vessel.getLocation().equals((Object)city.getCoordinates())) {
            this.logger.warn("The vessel is not in the city, but is moving, this can happen when a new destination is chosen after the ShipPositionUpdate task determined the ship entered the port, but the event was not yet handled.");
            return;
        }
        IShipOwner owner = vessel.getOwner();
        this.logger.debug("Current position of vessel ({}): {}", new Object[]{vessel.getName(), vessel.getLocation()});
        this.vessels.remove(vessel);
        if (!(owner instanceof IAIPlayer)) return;
        IAIPlayer player = (IAIPlayer)owner;
        IProductionConsumptionKnowledge knowlege = player.getProductionAndConsumptionKnowledge();
        knowlege.updateKnowledge(event.getCity());
        ITradeMissionData missionData = player.getTradeMission(vessel);
        if (missionData instanceof ISpecialMission) {
            if (!(missionData instanceof IBlockadeMission)) throw new IllegalStateException("The special mission " + missionData + " is not implemented");
            this.handleBlockadeMission(vessel, player, event.getCity());
            return;
        }
        player.updateTradeWaitingStatus(vessel, false);
        try {
            IAITradeStrategy strategy = (IAITradeStrategy)player.getTradeStrategyType(vessel).getStrategy();
            this.engineState.activateVesselForTrade(vessel);
            strategy.handleShipArrivesInPort((IShipEntersPortEvent)event);
            return;
        }
        catch (RuntimeException e) {
            this.logger.error("Failed to handle ship arrival of " + vessel.getName() + " of " + player.getName() + " " + player.getLastName(), (Throwable)e);
            return;
        }
        finally {
            this.engineState.deactivateVesselForTrade(vessel);
        }
    }

    @Subscribe
    public void handleGameLoad(GameStateChange gameStateChange) {
        if (gameStateChange.getStatusChange() == EGameStatusChange.LOAD_GAME_INIT) {
            this.shipEntersPortEventQueue = new ConcurrentLinkedQueue<ShipEntersPortEvent>();
            this.logger.info("Loading of a game was initialized. Queuing further ShipEntersPortEvent.");
        }
    }

    @Subscribe
    public void handleTradeStrategyStart(GraphInitialisationComplete event) {
        if (this.shipEntersPortEventQueue != null) {
            this.logger.info("Handle {} queued ShipEntersPortEvent after graph initialisation", new Object[]{this.shipEntersPortEventQueue.size()});
            while (!this.shipEntersPortEventQueue.isEmpty()) {
                ShipEntersPortEvent shipEntersPortEvent = this.shipEntersPortEventQueue.poll();
                this.handleShipArrival(shipEntersPortEvent);
            }
            this.shipEntersPortEventQueue = null;
        }
        if (this.disableService.aiTradingEnabled()) {
            for (IAIPlayer player : this.players) {
                ICity hometown = player.getHometown();
                IProductionConsumptionKnowledge knowlege = player.getProductionAndConsumptionKnowledge();
                knowlege.updateKnowledge(hometown);
                List shipList = player.getFleet();
                for (IShip ship : shipList) {
                    try {
                        if (player.isInitialized((INavigableVessel)ship)) continue;
                        this.initializeStrategyForVessel(player, (INavigableVessel)ship);
                    }
                    catch (RuntimeException e) {
                        this.logger.error("Failed to initialize strategy for ship  " + ship.getName() + " of " + player.getName() + " " + player.getLastName(), (Throwable)e);
                    }
                }
                List vesselList = player.getSelectableVessels();
                for (INavigableVessel ship : vesselList) {
                    this.startTradeStrategySteps(player, ship);
                }
            }
        }
    }

    private void startTradeStrategySteps(IAIPlayer player, INavigableVessel ship) {
        IAITradeStrategy tradeStrategy = (IAITradeStrategy)player.getTradeStrategyType(ship).getStrategy();
        if (!player.waitingForTradeStepToFinish(ship)) {
            tradeStrategy.executeTradeSteps(player, ship);
        } else {
            this.logger.warn("Skip starting of trade execution as waitingForTradeStepToFinish for {} of {} {} is {}", new Object[]{ship.getName(), player.getName(), player.getLastName(), player.waitingForTradeStepToFinish(ship)});
        }
    }

    private void handleBlockadeMission(INavigableVessel vessel, IAIPlayer player, ICity city) {
        DateTime now = this.date.getCurrentDate();
        ICity aldermanCity = this.mapService.getAldermanCity();
        if (city.equals(aldermanCity)) {
            if (this.blockadeState.entrySet().isEmpty()) {
                this.initializeStrategyForVessel(player, vessel);
            } else {
                for (Map.Entry entry : this.blockadeState.entrySet()) {
                    IBlockade blockade = (IBlockade)entry.getValue();
                    if (!blockade.getAssemblyDate().isBefore((ReadableInstant)now)) continue;
                    this.initializeStrategyForVessel(player, vessel);
                }
            }
        } else {
            this.initializeStrategyForVessel(player, vessel);
        }
    }

    public boolean executeCurrentTrade(INavigableVessel vessel) {
        return this.engineState.isActive(vessel);
    }

    @Subscribe
    public void handleWeeklyTasks(PeriodicalTimeWeekEndUpdate event) {
        if (this.disableService.aiTradingEnabled()) {
            for (IAIPlayer player : this.players) {
                List shipList = player.getSelectableVessels();
                for (INavigableVessel vessel : shipList) {
                    if (this.tradeChecker.isEngagedInTrading(vessel) || !this.tradeChecker.shouldBeTrading(vessel)) continue;
                    IAIPlayer owner = (IAIPlayer)vessel.getOwner();
                    this.logger.warn("The vessel {} of {} {} is currently not trading (position: {}), strategy={}: reinitialize", new Object[]{vessel.getName(), owner.getName(), owner.getLastName(), vessel.getLocation(), owner.getTradeStrategyType(vessel)});
                    this.clearRemainingTradeSteps(vessel, player);
                    this.initializeStrategyForVessel(player, vessel);
                    IAITradeStrategy tradeStrategy = (IAITradeStrategy)player.getTradeStrategyType(vessel).getStrategy();
                    tradeStrategy.executeTradeSteps(player, vessel);
                }
                IAIConstructionSelectionStrategy constructionStategy = (IAIConstructionSelectionStrategy)player.getConstructionSelectionType().getStrategy();
                if (!constructionStategy.shouldOrderNewConstruction(player)) continue;
                EShipType type = constructionStategy.shouldBuildShipType(player);
                ICity buildLocation = constructionStategy.getBuildLocation(player);
                constructionStategy.initShipConstruction(player, buildLocation, type);
            }
        }
    }

    private void clearRemainingTradeSteps(INavigableVessel vessel, IAIPlayer player) {
        while (player.hasMoreTradeSteps(vessel)) {
            player.getNextTradeStep(vessel);
        }
        player.setTradeMission(vessel, null);
    }

    @Subscribe
    public void handleSpecialMissionFinished(SpecialMissionFinishedEvent event) {
        INavigableVessel vessel = event.getVessel();
        IAIPlayer player = (IAIPlayer)vessel.getOwner();
        ICity city = event.getCity();
        this.logger.debug("Special mission for ship {} of {} {} ended in {}", new Object[]{vessel.getName(), player.getName(), player.getLastName(), city.getName()});
        ITradeMissionData missionData = event.getMissionData();
        if (missionData instanceof CollectConstructionWaresMissionData) {
            IShipyard shipyard = city.getCityState().getShipyardState();
            ShipyardOrderBuild shipConstructionOrder = new ShipyardOrderBuild(shipyard, ((CollectConstructionWaresMissionData)missionData).getShipType(), (IPlayer)player);
            this.shipyardEngine.handleOrderBuildEvent(shipConstructionOrder);
        }
        this.initializeRandomTradeStrategy(vessel, player);
        this.initializeStrategyForVessel(player, vessel);
        IAITradeStrategy tradeStrategy = (IAITradeStrategy)player.getTradeStrategyType(vessel).getStrategy();
        tradeStrategy.executeTradeSteps(player, vessel);
    }

    private void initializeRandomTradeStrategy(INavigableVessel vessel, IAIPlayer player) {
        List tradeStrategies = this.strategyHolderService.getTradeStrategies();
        player.setTradeStrategyType(vessel, (IAITradeStrategyType)tradeStrategies.get(this.rnd.nextInt(tradeStrategies.size())));
    }

    @Subscribe
    public void handleShipAuctionFinished(ShipAuctionFinished event) {
        IPlayer owner = event.getNewOwner();
        if (owner instanceof IAIPlayer) {
            IShip ship = event.getShip();
            ship.setOwner((IShipOwner)owner);
            owner.addShip(ship);
            this.initializeRandomTradeStrategy((INavigableVessel)ship, (IAIPlayer)owner);
            this.initializeStrategyForVessel((IAIPlayer)owner, (INavigableVessel)ship);
            this.startTradeStrategySteps((IAIPlayer)owner, (INavigableVessel)ship);
        }
    }

    @Subscribe
    public void handleShipNotAuction(ShipNotAuctioned event) {
        IShip ship = event.getShip();
        IPlayer owner = (IPlayer)ship.getOwner();
        if (owner instanceof IAIPlayer) {
            owner.addShip(ship);
            this.initializeRandomTradeStrategy((INavigableVessel)ship, (IAIPlayer)owner);
            this.initializeStrategyForVessel((IAIPlayer)owner, (INavigableVessel)ship);
            this.startTradeStrategySteps((IAIPlayer)owner, (INavigableVessel)ship);
        }
    }

    @Subscribe
    public void handleBuildingAuctionFinished(BuildingAuctionFinished event) {
        if (event.getNewOwner() instanceof IAIPlayer) {
            event.getBuilding().setOwner(event.getNewOwner());
        }
    }

    @Subscribe
    public void handleBuildingNotAuction(BuildingNotAuctioned event) {
    }

    @Override
    public void handleMarriageEvent(IAIPlayer player, MarriageBrokerAnnouncementState state) {
        IAIEventDecisionStrategy strategy = (IAIEventDecisionStrategy)player.getEventDecitionStrategyType().getStrategy();
        if (!player.getSpouseData().isPresent() && strategy.acceptMarriagBrokereOffer(player)) {
            int delay = this.rnd.nextInt(50) + 24;
            DateTime deadLine = state.getDate().plusDays(delay);
            MarriageOfferTask task = this.taskFactory.getMarriageOfferTask(player, state, deadLine);
            this.logger.debug("Add marriage offer task for {} {}", new Object[]{player.getName(), player.getLastName()});
            this.taskList.add((TimedTask)task);
            this.eventState.setMarriageState((IPlayer)player, EEventState.MARRIAGE_UNDER_CONSIDERATION);
        }
    }

    public void handleShipConstructionFinished(IShip ship, IAIPlayer player) {
        player.addShip(ship);
        this.initializeNewShip(ship, player);
    }

    @Override
    public void initializeNewShip(IShip ship, IAIPlayer player) {
        this.initializeRandomTradeStrategy((INavigableVessel)ship, player);
        this.initializeStrategyForVessel(player, (INavigableVessel)ship);
        this.startTradeStrategySteps(player, (INavigableVessel)ship);
    }
}

