/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.engine.event.EEventState;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.joda.time.DateTime;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class EventEngineState {
    @MapType(key=ICity.class, value=DateTime.class)
    private Map<ICity, DateTime> lastFire = new HashMap<ICity, DateTime>();
    @MapType(key=ICity.class, value=DateTime.class)
    private Map<ICity, DateTime> lastPlague = new HashMap<ICity, DateTime>();
    @MapType(key=IPlayer.class, value=EEventState.class)
    private Map<IPlayer, EEventState> marriageState = new HashMap<IPlayer, EEventState>();

    public void addFire(ICity city, DateTime date) {
        this.lastFire.put(city, date);
    }

    public Optional<DateTime> getLastFire(ICity city) {
        return Optional.ofNullable(this.lastFire.get(city));
    }

    public void addPlague(ICity city, DateTime date) {
        this.lastPlague.put(city, date);
    }

    public Optional<DateTime> getLastPlague(ICity city) {
        return Optional.ofNullable(this.lastPlague.get(city));
    }

    public void setMarriageState(IPlayer player, EEventState state) {
        this.marriageState.put(player, state);
    }

    public Optional<EEventState> getMarriageState(IPlayer player) {
        return Optional.ofNullable(this.marriageState.get(player));
    }

    public void resetMarriedState(IPlayer player) {
        this.marriageState.remove(player);
    }
}

