/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class LoanerCollectMoneyWithoutAuctionTimedTask
extends TimedTask {
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    private IDebt debt;
    private IPlayer debitor;

    public LoanerCollectMoneyWithoutAuctionTimedTask(IDebt debt, IPlayer debitor, DateTime deadline) {
        this.debt = debt;
        this.debitor = debitor;
        this.setExecutionTime(deadline);
    }

    public void run() {
        ICompany company = this.debitor.getCompany();
        int requiredAmount = this.debt.getAmount();
        int amount = (int)Math.min((long)requiredAmount, company.getCash());
        company.updateCash((long)(-amount));
        this.debitor.getCompany().updateCash((long)amount);
        if (this.debt.getCreditor() instanceof IPlayer) {
            ((IPlayer)this.debt.getCreditor()).getCompany().updateCash((long)amount);
            if (this.debt.getCreditor() instanceof IHumanPlayer) {
                DisplayMessage msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.LoanerEngine.paybackAfterWithoutAuction", new Object[]{this.debitor.getName(), this.debitor.getLastName(), amount});
                TargetedEvent message = new TargetedEvent((IHumanPlayer)this.debt.getCreditor(), (Object)msg);
                this.clientServerEventBus.post((Object)message);
            }
        }
    }
}

