/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.impl.ShipWeaponsLocationFactory;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class RefitShipTask
extends TimedTask {
    private final IShip ship;
    private final EShipUpgrade level;
    protected final ICityPlayerProxyJFX city;
    private final IShipyard shipyard;
    @Autowired
    @XStreamOmitField
    private ShipWeaponsLocationFactory shipWeaponLocationFactory;
    @Autowired
    @XStreamOmitField
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    @Qualifier(value="messageSource")
    private MessageSource messageSource;

    public RefitShipTask(DateTime executionTime, IShip ship, EShipUpgrade upgrade, ICityPlayerProxyJFX city, IShipyard shipyard) {
        this.setExecutionTime(executionTime);
        this.ship = ship;
        this.level = upgrade;
        this.city = city;
        this.shipyard = shipyard;
    }

    public void run() {
        while (this.ship.getShipUpgradeLevel() != this.level) {
            this.ship.upgrade();
            this.ship.setShipWeaponsLocation(this.shipWeaponLocationFactory.getShipWeaponsLocation(this.ship.getShipType(), this.level));
        }
        this.ship.setAvailable(true);
        this.city.getPlayersShips().add((Object)this.ship);
        this.shipyard.removeCompletedUpgrade(this.ship);
        if (this.city.getPlayersShips().size() == 1) {
            this.city.activateShip((INavigableVessel)this.ship);
        }
        int currentCapacity = this.ship.getCapacity();
        if (this.ship.getOwner() instanceof IHumanPlayer) {
            DisplayMessage msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.event.task.RefitShipTask.message", new Object[]{this.ship.getShipType(), this.level, currentCapacity});
            TargetedEvent displayMessage = new TargetedEvent((IHumanPlayer)this.ship.getOwner(), (Object)msg);
            this.clientServerEventBus.post((Object)displayMessage);
        }
    }
}

