/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.event.data.PeriodicalDailyUpdate;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.StateFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.GuildService;
import ch.sahits.game.openpatrician.dialog.ButtonTemplate;
import ch.sahits.game.openpatrician.dialog.DialogTemplate;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.event.task.LoanerCollectMoneyAfterAuctionTimedTask;
import ch.sahits.game.openpatrician.engine.event.task.LoanerCollectMoneyWithoutAuctionTimedTask;
import ch.sahits.game.openpatrician.engine.event.task.ServerSideTaskFactory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.DisplayTemplateMessage;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.ModelFactory;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ICreditor;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.LoanerList;
import ch.sahits.game.openpatrician.model.city.guild.GuildList;
import ch.sahits.game.openpatrician.model.city.guild.IGuild;
import ch.sahits.game.openpatrician.model.city.guild.IShipAuction;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.IReputation;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class LoanerEngine
extends AbstractEngine {
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private StateFactory factory;
    @Autowired
    private Date date;
    @Autowired
    private Random rnd;
    @Autowired
    private LoanerList loaners;
    @Autowired
    private StateFactory stateFactory;
    @Autowired
    private ModelFactory modelFactory;
    @Autowired
    private GuildList guildList;
    @Autowired
    private GuildService guildService;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private ServerSideTaskFactory taskFactory;

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
        this.taskList.add(this.taskFactory.getWeeklyLoanerCheck());
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
    }

    @Subscribe
    public void handleDailyUpdate(PeriodicalDailyUpdate event) {
        DateTime now = this.date.getCurrentDate();
        for (ILoaner loaner : this.loaners) {
            List debts = loaner.getDebts();
            Iterator iterator = debts.iterator();
            while (iterator.hasNext()) {
                IDebt debt = (IDebt)iterator.next();
                if (!debt.getDueDate().isBefore((ReadableInstant)now)) continue;
                ICitizen debitor = debt.getDebitor();
                int cash = (int)((double)debt.getAmount() * debt.getInterest());
                if (debitor instanceof IPlayer) {
                    IPlayer player = (IPlayer)debitor;
                    ICompany company = player.getCompany();
                    if (company.getCash() > (long)cash) {
                        company.updateCash((long)(-cash));
                        if (debt.getCreditor() instanceof IPlayer) {
                            ((IPlayer)debt.getCreditor()).getCompany().updateCash((long)cash);
                        }
                    } else {
                        this.postMessageDebtNotFulfillable(debt, loaner.getCity());
                    }
                } else if (debitor.getRank().equals((Object)ESocialRank.BARGAINER) || debitor.getRank().equals((Object)ESocialRank.CHANDLER) || debitor.getRank().equals((Object)ESocialRank.MERCHANT) || debitor.getRank().equals((Object)ESocialRank.TRADESMAN)) {
                    int payBack = this.rnd.nextInt(4);
                    if (payBack == 0) {
                        this.postMessageDebtNotFulfillable(debt, loaner.getCity());
                    } else if (debt.getCreditor() instanceof IPlayer) {
                        ((IPlayer)debt.getCreditor()).getCompany().updateCash((long)cash);
                    }
                } else if (debt.getCreditor() instanceof IPlayer) {
                    ((IPlayer)debt.getCreditor()).getCompany().updateCash((long)cash);
                }
                iterator.remove();
            }
        }
    }

    @VisibleForTesting
    void postMessageDebtNotFulfillable(IDebt debt, ICity city) {
        String titleTemplate = "ch.sahits.game.openpatrician.engine.land.city.LoanerEngine.paybackTitle";
        String messageTemplate = "ch.sahits.game.openpatrician.engine.land.city.LoanerEngine.paybackMessage";
        String remitBtnLbl = "ch.sahits.game.openpatrician.engine.land.city.LoanerEngine.remitBtn";
        String pawnBtnLbl = "ch.sahits.game.openpatrician.engine.land.city.LoanerEngine.pawnBtn";
        int sum = (int)((double)debt.getAmount() * debt.getInterest());
        Object[] messageArgs = new Object[]{debt.getDebitor().getName(), debt.getDebitor().getLastName(), sum};
        Runnable remit = this.createRemitRunnable(debt);
        Runnable pawn = this.createPawnRunnable(debt, city);
        ArrayList<ButtonTemplate> buttons = new ArrayList<ButtonTemplate>();
        ButtonTemplate remitBtn = ButtonTemplate.builder().action(remit).labelKey(remitBtnLbl).largeButton(true).build();
        ButtonTemplate pawnBtn = ButtonTemplate.builder().action(pawn).labelKey(pawnBtnLbl).largeButton(true).build();
        buttons.add(remitBtn);
        buttons.add(pawnBtn);
        DialogTemplate dialogTemplate = DialogTemplate.builder().titleKey(titleTemplate).messageKey(messageTemplate).messageArgs(messageArgs).buttons(buttons).closable(false).build();
        DisplayTemplateMessage displayMessage = new DisplayTemplateMessage(titleTemplate, dialogTemplate, new Object[0]);
        if (debt.getDebitor() instanceof IHumanPlayer) {
            TargetedEvent message = new TargetedEvent((IHumanPlayer)debt.getDebitor(), (Object)displayMessage);
            this.clientServerEventBus.post((Object)message);
        }
    }

    @VisibleForTesting
    Runnable createRemitRunnable(final IDebt debt) {
        return new Runnable(){

            @Override
            public void run() {
                ICreditor creditor = debt.getCreditor();
                if (creditor instanceof IPlayer) {
                    ICity city = debt.getDebitor().getHometown();
                    IReputation reputation = city.getReputation((IPlayer)creditor);
                    reputation.update(500);
                }
            }
        };
    }

    @VisibleForTesting
    Runnable createPawnRunnable(IDebt debt, ICity city) {
        return () -> {
            if (debt.getDebitor() instanceof IHumanPlayer) {
                this.pawnFromHumanDebitor(debt, city);
            } else if (debt.getCreditor() instanceof IHumanPlayer) {
                int value = this.rnd.nextInt(debt.getAmount() / 2) + debt.getAmount();
                value = (int)Math.min((double)value, (double)debt.getAmount() * debt.getInterest());
                ((IPlayer)debt.getCreditor()).getCompany().updateCash((long)value);
                ICitizen debitor = debt.getDebitor();
                DisplayMessage msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.land.city.LoanerEngine.pawnMsg1", new Object[]{debitor.getName(), debitor.getLastName(), value});
                TargetedEvent message = new TargetedEvent((IHumanPlayer)debt.getCreditor(), (Object)msg);
                this.clientServerEventBus.post((Object)message);
            }
        };
    }

    @VisibleForTesting
    void pawnFromHumanDebitor(IDebt debt, ICity city) {
        int sum = (int)((double)debt.getAmount() * debt.getInterest());
        IPlayer debitor = (IPlayer)debt.getDebitor();
        IShip shipMatch = null;
        int maxDelta = Integer.MAX_VALUE;
        for (IShip ship : debitor.getFleet()) {
            int shipValue = ship.getValue();
            if (Math.abs(shipValue - sum) >= maxDelta) continue;
            maxDelta = Math.abs(shipValue - sum);
            shipMatch = ship;
        }
        if (shipMatch != null) {
            DateTime auctionDate = this.date.getCurrentDate().plusDays(10);
            IGuild guild = (IGuild)this.guildList.findGuild(city).get();
            auctionDate = this.guildService.cleanUpAuctionAndDetermineAuctionDate(auctionDate, guild);
            IShipAuction auction = this.modelFactory.createShipAuction(auctionDate, shipMatch.getValue(), debitor, shipMatch);
            guild.getAuctions().add(auction);
            DateTime dateCollectMoney = auctionDate.plusDays(1);
            LoanerCollectMoneyAfterAuctionTimedTask collectMoney = this.taskFactory.getLoanerCollectMoneyAfterAuctionTask(debt, dateCollectMoney);
            this.taskList.add((TimedTask)collectMoney);
        } else {
            DateTime dateCollectMoney = this.date.getCurrentDate();
            LoanerCollectMoneyWithoutAuctionTimedTask collectMoney = this.taskFactory.getLoanerCollectMoneyTask(debt, debitor, dateCollectMoney);
            this.taskList.add((TimedTask)collectMoney);
        }
    }

    void addNewLoaner(ICity city) {
        this.factory.createLoaner(city);
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return new ArrayList<AbstractEngine>();
    }
}

