/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city.internal;

import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.engine.EngineFactory;
import ch.sahits.game.openpatrician.engine.land.city.internal.CityWallBuildingTask;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Treasury;
import ch.sahits.game.openpatrician.model.city.impl.CityWall;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.product.IWare;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class CityWallMaterialBuyingTask
extends TimedTask {
    private final ICityHall cityHall;
    @Autowired
    @XStreamOmitField
    private EngineFactory engineFactory;
    @Autowired
    private TimedUpdatableTaskList timedTaskListener;
    @Autowired
    @XStreamOmitField
    private ComputablePriceV2 computablePrice;
    @Autowired
    private Date date;

    public CityWallMaterialBuyingTask(ICityHall cityHall, DateTime electionTime) {
        this.cityHall = cityHall;
        this.setExecutionTime(electionTime);
    }

    public void run() {
        ICity city = this.cityHall.getCity();
        CityWall cityWall = city.getCityState().getCityWall();
        if (cityWall.getUsedBricks() == cityWall.getBoughtBricks()) {
            int amountRequired = Math.min(10, cityWall.getRequiredBricks() - cityWall.getBoughtBricks());
            int availableAmountCity = city.getWare((IWare)EWare.BRICK).getAmount();
            int avgPrice = this.computablePrice.buyPrice((ITradable)EWare.BRICK, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(amountRequired));
            if (avgPrice < 90) {
                int bought = city.move((IWare)EWare.BRICK, -amountRequired, this.cityHall.getMayor());
                cityWall.setBoughtBricks(cityWall.getBoughtBricks() - bought);
                avgPrice = this.computablePrice.buyPrice((ITradable)EWare.BRICK, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(-bought));
                ((Treasury)this.cityHall.getTreasury()).subtractBuildingCosts(avgPrice * bought);
                DateTime buildDate = this.date.getCurrentDate().plusDays(5);
                CityWallBuildingTask task = this.engineFactory.getCityWallBuildingTask(cityWall, buildDate);
                this.timedTaskListener.add((TimedTask)task);
            }
        }
    }
}

