/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.engine.player.strategy.EAIRepairStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.EAITradeStrategyType;
import ch.sahits.game.openpatrician.engine.player.strategy.ECollectWareStrategyType;
import ch.sahits.game.openpatrician.engine.player.strategy.EEventDecisionStrategyType;
import ch.sahits.game.openpatrician.engine.player.strategy.EGuildJoinStrategyType;
import ch.sahits.game.openpatrician.engine.player.strategy.EHireCaptainStrategyType;
import ch.sahits.game.openpatrician.engine.player.strategy.EShipConstructionStrategyType;
import ch.sahits.game.openpatrician.engine.player.strategy.ETakeLoanStrategyType;
import ch.sahits.game.openpatrician.model.player.IAICaptainHireStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIConstructionSelectionStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIEventDecisionStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIGuildJoinStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIShipRepairStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIStrategyProvider;
import ch.sahits.game.openpatrician.model.player.IAITakeLoanStrategyType;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class DefaultStrategyProvider
implements IAIStrategyProvider {
    @ListType(value=IAIShipRepairStrategyType.class)
    private static List<IAIShipRepairStrategyType> repairStrategies = new ArrayList<IAIShipRepairStrategyType>();
    @ListType(value=IAIShipRepairStrategyType.class)
    private static List<IAITradeStrategyType> tradeStrategies = new ArrayList<IAITradeStrategyType>();
    @ListType(value=IAITradeStrategyType.class)
    private static List<IAITakeLoanStrategyType> takeLoanStrategies = new ArrayList<IAITakeLoanStrategyType>();
    @ListType(value=IAIConstructionSelectionStrategyType.class)
    private static List<IAIConstructionSelectionStrategyType> constructionSelections = new ArrayList<IAIConstructionSelectionStrategyType>();
    @ListType(value=IAICaptainHireStrategyType.class)
    private static List<IAICaptainHireStrategyType> hireCaptainStrategies = new ArrayList<IAICaptainHireStrategyType>();
    @ListType(value=IAICaptainHireStrategyType.class)
    private static List<IAIGuildJoinStrategyType> guildJoinStrategies = new ArrayList<IAIGuildJoinStrategyType>();
    @ListType(value=IAIEventDecisionStrategyType.class)
    private static List<IAIEventDecisionStrategyType> eventDecisionStrategies = new ArrayList<IAIEventDecisionStrategyType>();
    @Autowired
    private ApplicationContext context;

    @PostConstruct
    private void init() {
        repairStrategies.add(EAIRepairStrategy.EIGHTY_PERCENT);
        repairStrategies.add(EAIRepairStrategy.ONLY_HOMEWOTN);
        repairStrategies.add(EAIRepairStrategy.ONLY_KONTOR_TYPE);
        repairStrategies.add(EAIRepairStrategy.ONLY_TRADINGOFFICE);
        repairStrategies.add(EAIRepairStrategy.ONLY_WEST);
        for (IAIShipRepairStrategyType iAIShipRepairStrategyType : repairStrategies) {
            ((EAIRepairStrategy)iAIShipRepairStrategyType).setApplicationContext(this.context);
        }
        tradeStrategies.add(EAITradeStrategyType.SUPPLY_HOMETOWN);
        tradeStrategies.add(EAITradeStrategyType.CHEAP_PRODUCTION);
        tradeStrategies.add(EAITradeStrategyType.TRADE_ROUTE);
        tradeStrategies.add(EAITradeStrategyType.PRODUCTION_CHAIN);
        for (IAITradeStrategyType iAITradeStrategyType : tradeStrategies) {
            ((EAITradeStrategyType)iAITradeStrategyType).setApplicationContext(this.context);
        }
        takeLoanStrategies.add(ETakeLoanStrategyType.LOW_MONEY_LONG_DURATION);
        for (IAITakeLoanStrategyType iAITakeLoanStrategyType : takeLoanStrategies) {
            ((ETakeLoanStrategyType)iAITakeLoanStrategyType).setApplicationContext(this.context);
        }
        constructionSelections.add(EShipConstructionStrategyType.HOMETOWN_BIGEST);
        for (IAIConstructionSelectionStrategyType iAIConstructionSelectionStrategyType : constructionSelections) {
            ((EShipConstructionStrategyType)iAIConstructionSelectionStrategyType).setApplicationContext(this.context);
        }
        for (EHireCaptainStrategyType eHireCaptainStrategyType : EHireCaptainStrategyType.values()) {
            hireCaptainStrategies.add(eHireCaptainStrategyType);
            eHireCaptainStrategyType.setApplicationContext(this.context);
        }
        for (Enum enum_ : EGuildJoinStrategyType.values()) {
            guildJoinStrategies.add((IAIGuildJoinStrategyType)enum_);
            ((EGuildJoinStrategyType)enum_).setApplicationContext(this.context);
        }
        for (Enum enum_ : EEventDecisionStrategyType.values()) {
            eventDecisionStrategies.add((IAIEventDecisionStrategyType)enum_);
            ((EEventDecisionStrategyType)enum_).setApplicationContext(this.context);
        }
        for (Enum enum_ : ECollectWareStrategyType.values()) {
            ((ECollectWareStrategyType)enum_).setApplicationContext(this.context);
        }
    }

    public List<IAITradeStrategyType> getTradeStrategies() {
        return tradeStrategies;
    }

    public List<IAIShipRepairStrategyType> getRepairStrategies() {
        return repairStrategies;
    }

    public List<IAITakeLoanStrategyType> getTakeLoanStrategies() {
        return takeLoanStrategies;
    }

    public List<IAIConstructionSelectionStrategyType> getConstructionSelectionStrategies() {
        return constructionSelections;
    }

    public List<IAICaptainHireStrategyType> getCaptainHireStrategies() {
        return hireCaptainStrategies;
    }

    public List<IAIGuildJoinStrategyType> getGuildJoinStrategies() {
        return guildJoinStrategies;
    }

    public List<IAIEventDecisionStrategyType> getEventDecisionStrategies() {
        return eventDecisionStrategies;
    }
}

