/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.event.data.BuildingAuctionFinished;
import ch.sahits.game.event.data.BuildingNotAuctioned;
import ch.sahits.game.event.data.ShipAuctionFinished;
import ch.sahits.game.event.data.ShipNotAuctioned;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.PlayerList;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class HumanPlayerEngine
extends AbstractEngine {
    @Autowired
    private PlayerList players;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private ShipService shipService;

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return new ArrayList<AbstractEngine>();
    }

    List<IPlayer> getHumanPlayers() {
        return this.players.stream().filter(p -> p instanceof IHumanPlayer).collect(Collectors.toList());
    }

    @Subscribe
    public void handleShipAuctionFinished(ShipAuctionFinished event) {
        IPlayer owner = event.getNewOwner();
        if (owner instanceof IHumanPlayer) {
            IShip ship = event.getShip();
            ship.setOwner((IShipOwner)owner);
            owner.addShip(ship);
            Optional city = this.shipService.findCity((INavigableVessel)ship);
            DisplayMessage msg = city.isPresent() ? new DisplayMessage("ch.sahits.game.openpatrician.engine.player.HumanPlayerEngine.shipAuctioned", new Object[]{ship.getName(), ((ICity)city.get()).getName()}) : new DisplayMessage("ch.sahits.game.openpatrician.engine.player.HumanPlayerEngine.shipAuctionedOnSea", new Object[]{ship.getName()});
            TargetedEvent targetMsg = new TargetedEvent((IHumanPlayer)owner, (Object)msg);
            this.clientServerEventBus.post((Object)targetMsg);
        }
    }

    @Subscribe
    public void handleShipNotAuction(ShipNotAuctioned event) {
        IShipOwner owner = event.getShip().getOwner();
        if (owner instanceof IHumanPlayer) {
            IShip ship = event.getShip();
            ((IHumanPlayer)owner).addShip(ship);
            Optional city = this.shipService.findCity((INavigableVessel)ship);
            DisplayMessage msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.player.HumanPlayerEngine.shipNotAuctioned", new Object[]{ship.getName(), ((ICity)city.get()).getName()});
            TargetedEvent targetMsg = new TargetedEvent((IHumanPlayer)event.getNewOwner(), (Object)msg);
            this.clientServerEventBus.post((Object)targetMsg);
        }
    }

    @Subscribe
    public void handleBuildingAuctionFinished(BuildingAuctionFinished event) {
        IPlayer owner = event.getNewOwner();
        if (owner instanceof IHumanPlayer) {
            IBuilding building = event.getBuilding();
            building.setOwner(owner);
            ICity city = building.getCity();
            DisplayMessage msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.player.HumanPlayerEngine.buildingAuctioned", new Object[]{city.getName()});
            TargetedEvent targetMsg = new TargetedEvent((IHumanPlayer)owner, (Object)msg);
            this.clientServerEventBus.post((Object)targetMsg);
        }
    }

    @Subscribe
    public void handleBuildingNotAuction(BuildingNotAuctioned event) {
        if (event.getNewOwner() instanceof IHumanPlayer) {
            ICity city = event.getBuilding().getCity();
            DisplayMessage msg = new DisplayMessage("ch.sahits.game.openpatrician.engine.player.HumanPlayerEngine.buildingNotAuctioned", new Object[]{city.getName()});
            TargetedEvent targetMsg = new TargetedEvent((IHumanPlayer)event.getNewOwner(), (Object)msg);
            this.clientServerEventBus.post((Object)targetMsg);
        }
    }
}

