/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.clientserverinterface.service.GuildService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.guild.GuildList;
import ch.sahits.game.openpatrician.model.city.guild.IGuild;
import ch.sahits.game.openpatrician.model.player.IAIGuildJoinStrategy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@LazySingleton
public class AlwaysJoinGuildMinCashStrategy
implements IAIGuildJoinStrategy {
    private static final int ENTRY_FEE_FACTOR = 10;
    @Autowired
    private GuildList guildList;
    @Autowired
    private GuildService guildService;

    public boolean shouldJoin(IAIPlayer player, ICity city, Optional<INavigableVessel> vessel) {
        Optional maybeGuild = this.guildList.findGuild(city);
        if (maybeGuild.isPresent()) {
            IGuild guild = (IGuild)maybeGuild.get();
            if (guild.getMembers().contains(player)) {
                return false;
            }
            ICompany company = player.getCompany();
            int fee = this.guildService.getEntryFee((IPlayer)player);
            if ((long)(fee * 10) < company.getCash()) {
                return true;
            }
        }
        return false;
    }

    public void join(IAIPlayer player, ICity city) {
        ICompany company = player.getCompany();
        Optional maybeGuild = this.guildList.findGuild(city);
        IGuild guild = (IGuild)maybeGuild.get();
        int fee = this.guildService.getEntryFee((IPlayer)player);
        company.updateCash((long)(-fee));
        guild.join((IPlayer)player);
    }
}

