/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.service.CelebrationService;
import ch.sahits.game.openpatrician.engine.player.CollectWaresForCity;
import ch.sahits.game.openpatrician.engine.player.CollectWaresMissionData;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectionWaresStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.ECollectWareStrategyType;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN})
public class CollectCelebrationWaresStrategy
extends CollectionWaresStrategy {
    @XStreamOmitField
    private ICity celebrationLocation;
    @Autowired
    private CelebrationService celebrationService;

    @Override
    protected CollectWaresMissionData createMissionData(IAIPlayer player) {
        Preconditions.checkNotNull((Object)this.celebrationLocation);
        ICity where = this.celebrationLocation;
        CollectWaresForCity missionData = new CollectWaresForCity();
        missionData.setCity(where);
        HashMap<EPopulationClass, Integer> population = new HashMap<EPopulationClass, Integer>();
        for (EPopulationClass populationClass : EPopulationClass.values()) {
            population.put(populationClass, where.getPopulation(populationClass));
        }
        Map requirements = this.celebrationService.calculateRequiredAmounts(population);
        Optional optOffice = player.findTradingOffice(where);
        for (IWare ware : requirements.keySet()) {
            int amount = !optOffice.isPresent() ? (Integer)requirements.get(ware) : Math.max((Integer)requirements.get(ware) - ((ITradingOffice)optOffice.get()).getWare(ware).getAmount(), 0);
            missionData.require(ware, amount);
        }
        missionData.setInitialRequirements(missionData.getRequiredWareAmounts());
        return missionData;
    }

    @Override
    protected boolean checkAllWaresCollected(ICity city, INavigableVessel vessel, CollectWaresMissionData tradeMission, Optional<ITradingOffice> tradingOffice) {
        Map<IWare, Integer> initialRequirements = ((CollectWaresForCity)tradeMission).getInitialRequirements();
        for (IWare ware : initialRequirements.keySet()) {
            int amount = !tradingOffice.isPresent() || !city.equals(this.celebrationLocation) ? initialRequirements.get(ware) : Math.max(initialRequirements.get(ware) - tradingOffice.get().getWare(ware).getAmount(), 0);
            amount = Math.max(amount - vessel.getWare(ware).getAmount(), 0);
            tradeMission.require(ware, amount);
        }
        for (Integer amount : tradeMission.getRequiredWareAmounts().values()) {
            if (amount <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected IAITradeStrategyType getStrategyType() {
        return ECollectWareStrategyType.CELEBRATION;
    }

    public void setCelebrationLocation(ICity celebrationLocation) {
        this.celebrationLocation = celebrationLocation;
    }
}

