/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.IAIEventDecisionStrategy;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@LazySingleton
public class StorageBasedEventDecisionStrategy
implements IAIEventDecisionStrategy {
    @MapType(key=IWare.class, value=Integer.class)
    private Map<IWare, Integer> minAmounts = new HashMap<IWare, Integer>();

    public StorageBasedEventDecisionStrategy() {
        this.minAmounts.put((IWare)EWare.BEER, 20);
        this.minAmounts.put((IWare)EWare.WINE, 20);
        this.minAmounts.put((IWare)EWare.FISH, 2);
        this.minAmounts.put((IWare)EWare.MEAT, 2);
        this.minAmounts.put((IWare)EWare.GRAIN, 3);
        this.minAmounts.put((IWare)EWare.HONEY, 10);
    }

    public boolean acceptMarriagBrokereOffer(IAIPlayer player) {
        return this.enoughStored((IPlayer)player, player.getHometown());
    }

    public boolean acceptMarriageOffer(IAIPlayer player) {
        return this.enoughStored((IPlayer)player, player.getHometown());
    }

    public boolean shouldOrderCelebration(IAIPlayer player, ICity city) {
        return this.enoughStored((IPlayer)player, city);
    }

    private boolean enoughStored(IPlayer player, ICity city) {
        Optional optOffice = player.findTradingOffice(city);
        if (optOffice.isPresent()) {
            for (IWare ware : this.minAmounts.keySet()) {
                ITradingOffice office = (ITradingOffice)optOffice.get();
                AmountablePrice stored = office.getWare(ware);
                if (stored.getAmount() >= this.minAmounts.get(ware)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

