/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.engine.player.tradesteps.BuyTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.SellDumpTradeStep;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@Prototype
public abstract class AbstractAggregateDumpTradeStep
implements ITradeStep {
    private INavigableVessel vessel;
    private ICity city;
    private boolean executeNext = true;
    @Autowired
    @XStreamOmitField
    private ApplicationContext context;
    @ListType(value=BuyTradeStep.class)
    private ArrayList<SellDumpTradeStep> tradeSteps = new ArrayList();

    public void addSellStep(IWare ware) {
        SellDumpTradeStep sellStep = (SellDumpTradeStep)this.context.getBean(SellDumpTradeStep.class);
        sellStep.setCity(this.city);
        sellStep.setVessel(this.vessel);
        sellStep.setWare(ware);
        this.tradeSteps.add(sellStep);
    }

    public boolean execute() {
        Preconditions.checkArgument((boolean)this.vessel.getLocation().equals((Object)this.city.getCoordinates()), (Object)("The vessel is not in city " + this.city.getName() + " but at " + this.vessel.getLocation()));
        for (SellDumpTradeStep buyTradeStep : this.tradeSteps) {
            if (this.vessel.getWare(buyTradeStep.getWare()).getAmount() <= 0) continue;
            buyTradeStep.execute();
        }
        return this.executeNext;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.tradeSteps.stream().forEach(step -> sb.append(step.getWare().name()).append(" "));
        return this.getClass().getSimpleName() + " in " + this.city.getName() + " buying: " + sb.toString().toString();
    }

    public void setVessel(INavigableVessel vessel) {
        this.vessel = vessel;
    }

    public INavigableVessel getVessel() {
        return this.vessel;
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    public void setExecuteNext(boolean executeNext) {
        this.executeNext = executeNext;
    }
}

