/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.engine.player.tradesteps.BuyTradeStep;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class AggregatedBuyTradeStep
implements ITradeStep {
    private INavigableVessel vessel;
    private ICity city;
    private boolean executeNext = true;
    @Autowired
    @XStreamOmitField
    private ApplicationContext context;
    @ListType(value=BuyTradeStep.class)
    private ArrayList<BuyTradeStep> tradeSteps = new ArrayList();

    public void addBuyStep(IWare ware, int maxPrice) {
        BuyTradeStep buyStep = (BuyTradeStep)this.context.getBean(BuyTradeStep.class);
        buyStep.setExecuteNext(this.executeNext);
        buyStep.setMaxBuyPrice(maxPrice);
        buyStep.setCity(this.city);
        buyStep.setVessel(this.vessel);
        buyStep.setWare(ware);
        this.tradeSteps.add(buyStep);
    }

    private List<BuyTradeStep> getPriorityList() {
        ArrayList<BuyTradeStep> list = new ArrayList<BuyTradeStep>();
        HashMap<BuyTradeStep, Integer> loadedWares = new HashMap<BuyTradeStep, Integer>();
        for (BuyTradeStep step : this.tradeSteps) {
            IWare ware = step.getWare();
            int amount = this.vessel.getWare(ware).getAmount();
            loadedWares.put(step, amount);
        }
        loadedWares.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(entry -> list.add((BuyTradeStep)entry.getKey()));
        return list;
    }

    public boolean execute() {
        Preconditions.checkArgument((boolean)this.vessel.getLocation().equals((Object)this.city.getCoordinates()), (Object)("The vessel is not in city " + this.city.getName() + " but at " + this.vessel.getLocation()));
        List<BuyTradeStep> priorityList = this.getPriorityList();
        for (BuyTradeStep buyTradeStep : priorityList) {
            buyTradeStep.execute();
            if (this.vessel.getCapacity() != 0) continue;
            break;
        }
        return this.executeNext;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.tradeSteps.stream().forEach(step -> sb.append(step.getWare().name()).append(" "));
        return "AggregatedBuyTradeStep in " + this.city.getName() + " buying: " + sb.toString().toString();
    }

    public void setVessel(INavigableVessel vessel) {
        this.vessel = vessel;
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    public void setExecuteNext(boolean executeNext) {
        this.executeNext = executeNext;
    }
}

