/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AbstractBuyTradeStep;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class BuyTradeStep
extends AbstractBuyTradeStep {
    private int maxBuyPrice;
    @Autowired
    @XStreamOmitField
    private ComputablePriceV2 computablePrice;

    public boolean execute() {
        int capacity;
        IWare ware = this.getWare();
        INavigableVessel vessel = this.getVessel();
        int availableAmount = this.getCity().getWare(ware).getAmount();
        IPlayer player = (IPlayer)vessel.getOwner();
        ICompany company = player.getCompany();
        int maxAmount = capacity = vessel.getCapacity();
        if (!ware.isBarrelSizedWare()) {
            maxAmount /= 10;
        }
        int affordableAmount = this.computablePrice.calculateBuyAmount((ITradable)ware, availableAmount, this.maxBuyPrice, maxAmount, company.getCash());
        return this.buyWare(availableAmount, player, company, affordableAmount);
    }

    public void setMaxBuyPrice(int maxBuyPrice) {
        this.maxBuyPrice = maxBuyPrice;
    }
}

