/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class BuyTradingOfficeTradeStep
implements ITradeStep {
    private ICity city;
    private ITradingOffice tradingOffice;
    private IWare ware;
    @Autowired
    @XStreamOmitField
    private ComputablePriceV2 computablePrice;
    private int maxBuyPrice;

    private boolean buyWare(int availableAmount, IPlayer player, ICompany company, int affordableAmount) {
        if (affordableAmount > 0 && this.tradingOffice != null) {
            int buyPrice = this.computablePrice.buyPrice((ITradable)this.ware, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(availableAmount), (IntegerBinding)new ConstantIntegerBinding(affordableAmount));
            company.updateCash((long)(-buyPrice * affordableAmount));
            this.city.move(this.ware, -affordableAmount, (ICitizen)player);
            this.tradingOffice.move(this.ware, affordableAmount, buyPrice);
        }
        return true;
    }

    public boolean execute() {
        int capacity;
        IWare ware = this.getWare();
        int availableAmount = this.getCity().getWare(ware).getAmount();
        IPlayer player = this.tradingOffice.getOwner();
        ICompany company = player.getCompany();
        int maxAmount = capacity = this.tradingOffice.capacityProperty().get() - this.tradingOffice.getOccupiedSpace();
        if (!ware.isBarrelSizedWare()) {
            maxAmount /= 10;
        }
        int affordableAmount = this.computablePrice.calculateBuyAmount((ITradable)ware, availableAmount, this.maxBuyPrice, maxAmount, company.getCash());
        return this.buyWare(availableAmount, player, company, affordableAmount);
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    protected ICity getCity() {
        return this.city;
    }

    public void setTradingOffice(ITradingOffice tradingOffice) {
        this.tradingOffice = tradingOffice;
    }

    public ITradingOffice getTradingOffice() {
        return this.tradingOffice;
    }

    public void setWare(IWare ware) {
        this.ware = ware;
    }

    public IWare getWare() {
        return this.ware;
    }

    public void setMaxBuyPrice(int maxBuyPrice) {
        this.maxBuyPrice = maxBuyPrice;
    }
}

